/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.shibboleth;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.InvalidPropertyValueException;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.shibboleth.computedgroups.ELGroupComputerHelper;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.exceptions.GroupAlreadyExistsException;
import org.nuxeo.runtime.api.Framework;

public class ShibbolethGroupHelper {
    private ShibbolethGroupHelper() {
    }

    protected static DirectoryService getDirectoryService() {
        return (DirectoryService)Framework.getService(DirectoryService.class);
    }

    protected static UserManager getUserManager() {
        return (UserManager)Framework.getService(UserManager.class);
    }

    public static DocumentModel getBareGroupModel(CoreSession core) {
        return core.createDocumentModel("shibbGroup");
    }

    public static DocumentModel createGroup(DocumentModel group) {
        try (Session session = ShibbolethGroupHelper.getDirectoryService().open("shibbGroup");){
            if (session.hasEntry(group.getPropertyValue("shibbolethGroup:groupName").toString())) {
                throw new GroupAlreadyExistsException();
            }
            ShibbolethGroupHelper.checkExpressionLanguageValidity(group);
            DocumentModel documentModel = group = session.createEntry(group);
            return documentModel;
        }
    }

    public static DocumentModel getGroup(String groupName) throws DirectoryException {
        try (Session session = ShibbolethGroupHelper.getDirectoryService().open("shibbGroup");){
            DocumentModel documentModel = session.getEntry(groupName);
            return documentModel;
        }
    }

    public static void updateGroup(DocumentModel group) {
        try (Session session = ShibbolethGroupHelper.getDirectoryService().open("shibbGroup");){
            ShibbolethGroupHelper.checkExpressionLanguageValidity(group);
            session.updateEntry(group);
        }
    }

    public static void deleteGroup(DocumentModel group) {
        try (Session session = ShibbolethGroupHelper.getDirectoryService().open("shibbGroup");){
            session.deleteEntry(group);
        }
    }

    public static List<String> getParentsGroups(String shibbGroupName) {
        Directory dir = ShibbolethGroupHelper.getDirectoryService().getDirectory(ShibbolethGroupHelper.getUserManager().getGroupDirectoryName());
        Reference subGroups = dir.getReference(ShibbolethGroupHelper.getUserManager().getGroupSubGroupsField());
        List ret = subGroups.getSourceIdsForTarget(shibbGroupName);
        return ret;
    }

    public static DocumentModelList getGroups() {
        try (Session session = ShibbolethGroupHelper.getDirectoryService().open("shibbGroup");){
            DocumentModelList documentModelList = session.getEntries();
            return documentModelList;
        }
    }

    public static DocumentModelList searchGroup(String fullText) {
        try (Session session = ShibbolethGroupHelper.getDirectoryService().open("shibbGroup");){
            HashMap<String, String> filters = new HashMap<String, String>();
            if (fullText != null && !"".equals(fullText)) {
                filters.put("groupName", fullText);
            }
            HashMap<String, String> orderBy = new HashMap<String, String>();
            orderBy.put("groupName", "asc");
            DocumentModelList documentModelList = session.query(filters, new HashSet(filters.keySet()), orderBy);
            return documentModelList;
        }
    }

    protected static void checkExpressionLanguageValidity(DocumentModel group) {
        String expressionLanguage = (String)((Object)group.getPropertyValue("shibbolethGroup:expressionLanguage"));
        if (!ELGroupComputerHelper.isValidEL(expressionLanguage)) {
            throw new InvalidPropertyValueException(expressionLanguage + " : is not a valid expression language");
        }
    }
}

