/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheManagement;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.EntrySource;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;

public class DirectoryCache {
    private static final Logger log = LogManager.getLogger(DirectoryCache.class);
    private static final Serializable CACHE_MISS = Boolean.FALSE;
    protected final String name;
    protected Cache entryCache;
    protected String entryCacheName = null;
    protected Cache entryCacheWithoutReferences;
    protected String entryCacheWithoutReferencesName = null;
    protected boolean negativeCaching;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Counter hitsCounter;
    protected final Counter negativeHitsCounter;
    protected final Counter missesCounter;
    protected final Counter invalidationsCounter;
    protected final Counter sizeCounter;

    protected DirectoryCache(String name) {
        this.name = name;
        this.hitsCounter = this.registry.counter(MetricName.build((String[])new String[]{"nuxeo", "directories", "directory", "cache", "hit"}).tagged(new String[]{"directory", name}));
        this.negativeHitsCounter = this.registry.counter(MetricName.build((String[])new String[]{"nuxeo", "directories", "directory", "cache", "hit", "null"}).tagged(new String[]{"directory", name}));
        this.missesCounter = this.registry.counter(MetricName.build((String[])new String[]{"nuxeo", "directories", "directory", "cache", "miss"}).tagged(new String[]{"directory", name}));
        this.invalidationsCounter = this.registry.counter(MetricName.build((String[])new String[]{"nuxeo", "directories", "directory", "cache", "invalidation"}).tagged(new String[]{"directory", name}));
        this.sizeCounter = this.registry.counter(MetricName.build((String[])new String[]{"nuxeo", "directories", "directory", "cache", "size"}).tagged(new String[]{"directory", name}));
    }

    protected boolean isCacheEnabled() {
        return this.entryCacheName != null && this.entryCacheWithoutReferencesName != null;
    }

    public DocumentModel getEntry(String entryId, EntrySource source) {
        return this.getEntry(entryId, source, true);
    }

    public DocumentModel getEntry(String entryId, EntrySource source, boolean fetchReferences) {
        if (!this.isCacheEnabled()) {
            log.error("NPS: Cache is disabled => returning entry from source for " + entryId);
            return source.getEntryFromSource(entryId, fetchReferences);
        }
        if (this.isCacheEnabled() && (this.getEntryCache() == null || this.getEntryCacheWithoutReferences() == null)) {
            if (log.isDebugEnabled()) {
                if (this.getEntryCache() == null) {
                    log.error("The cache: {} is undefined for directory: {}, it will be created with the default cache configuration", (Object)this.entryCacheName, (Object)this.name);
                }
                if (this.getEntryCacheWithoutReferences() == null) {
                    log.error("The cache: {} is undefined for directory: {}, it will be created with the default cache configuration", (Object)this.entryCacheWithoutReferencesName, (Object)this.name);
                }
            }
            return source.getEntryFromSource(entryId, fetchReferences);
        }
        Cache cache = fetchReferences ? this.getEntryCache() : this.getEntryCacheWithoutReferences();
        Serializable entry = cache.get(entryId);
        if (CACHE_MISS.equals(entry)) {
            this.negativeHitsCounter.inc();
            return null;
        }
        DocumentModel dm = (DocumentModel)entry;
        if (dm == null) {
            log.error("NPS: Entity {} with fetchReference={} WAS NOT FOUND in the cache {} with size={}", (Object)entryId, (Object)fetchReferences, (Object)cache.getName(), (Object)((CacheManagement)cache).getSize());
            if (!Framework.isBooleanPropertyFalse((String)"nuxeo.cache.add.trace") && Framework.getProperty((String)"tracker.username", (String)"mk02097186@gmail.com").equals(entryId)) {
                log.error("Who's fetching entity not in the cache", (Throwable)new Exception());
            }
            if ((dm = source.getEntryFromSource(entryId, fetchReferences)) != null) {
                try {
                    dm.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                ((CacheManagement)cache).putLocal(entryId, (Serializable)dm);
                if (fetchReferences) {
                    this.sizeCounter.inc();
                }
            } else if (this.negativeCaching) {
                ((CacheManagement)cache).putLocal(entryId, CACHE_MISS);
            }
            this.missesCounter.inc();
        } else {
            this.hitsCounter.inc();
            log.error("NPS: Entity {} with fetchReference={} was found in the cache {} with size={}", (Object)entryId, (Object)fetchReferences, (Object)cache.getName(), (Object)((CacheManagement)cache).getSize());
        }
        try {
            if (dm == null) {
                return null;
            }
            DocumentModel clone = dm.clone();
            if (BaseSession.isReadOnlyEntry(dm)) {
                BaseSession.setReadOnlyEntry(clone);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return dm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(List<String> entryIds) {
        if (this.isCacheEnabled()) {
            DirectoryCache directoryCache = this;
            synchronized (directoryCache) {
                for (String entryId : entryIds) {
                    this.sizeCounter.dec();
                    this.invalidationsCounter.inc();
                    Cache cache = this.getEntryCache();
                    if (cache != null) {
                        cache.invalidate(entryId);
                    }
                    if ((cache = this.getEntryCacheWithoutReferences()) == null) continue;
                    cache.invalidate(entryId);
                }
            }
        }
    }

    public void invalidate(String ... entryIds) {
        this.invalidate(Arrays.asList(entryIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll() {
        if (this.isCacheEnabled()) {
            DirectoryCache directoryCache = this;
            synchronized (directoryCache) {
                long count = this.sizeCounter.getCount();
                this.sizeCounter.dec(count);
                this.invalidationsCounter.inc(count);
                Cache cache = this.getEntryCache();
                if (cache != null) {
                    cache.invalidateAll();
                }
                if ((cache = this.getEntryCacheWithoutReferences()) != null) {
                    cache.invalidateAll();
                }
            }
        }
    }

    public void setEntryCacheName(String entryCacheName) {
        this.entryCacheName = entryCacheName;
    }

    public void setEntryCacheWithoutReferencesName(String entryCacheWithoutReferencesName) {
        this.entryCacheWithoutReferencesName = entryCacheWithoutReferencesName;
    }

    public void setNegativeCaching(Boolean negativeCaching) {
        this.negativeCaching = Boolean.TRUE.equals(negativeCaching);
    }

    public Cache getEntryCache() {
        if (this.entryCache == null) {
            this.entryCache = this.getCacheService().getCache(this.entryCacheName);
        }
        return this.entryCache;
    }

    public Cache getEntryCacheWithoutReferences() {
        if (this.entryCacheWithoutReferences == null) {
            this.entryCacheWithoutReferences = this.getCacheService().getCache(this.entryCacheWithoutReferencesName);
        }
        return this.entryCacheWithoutReferences;
    }

    protected CacheService getCacheService() {
        CacheService cacheService = (CacheService)Framework.getService(CacheService.class);
        if (cacheService == null) {
            throw new NuxeoException("Missing CacheService");
        }
        return cacheService;
    }
}

