/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.util.ArrayList;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class UserManagerHelper {
    private UserManagerHelper() {
    }

    public static void addUserToGroup(NuxeoPrincipal principal, NuxeoGroup group) {
        UserManagerHelper.addUserToGroup(principal, group, false);
    }

    public static void addUserToGroup(NuxeoPrincipal principal, NuxeoGroup group, boolean loadGroupMembers) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        String groupName = group.getName();
        if (!BaseSession.isReadOnlyEntry((DocumentModel)principal.getModel())) {
            ArrayList<String> groups = principal.getGroups();
            if (groups == null) {
                groups = new ArrayList<String>();
            }
            if (!groups.contains(groupName)) {
                groups.add(groupName);
                principal.setGroups(groups);
                userManager.updateUser(principal.getModel());
            }
        } else {
            String userName;
            ArrayList<String> users;
            if (loadGroupMembers) {
                group = userManager.getGroup(groupName);
            }
            if ((users = group.getMemberUsers()) == null) {
                users = new ArrayList<String>();
            }
            if (!users.contains(userName = principal.getName())) {
                users.add(userName);
                group.setMemberUsers(users);
                userManager.updateGroup(group.getModel());
            }
        }
    }

    public static void addGroupToGroup(NuxeoGroup subgroup, String groupName) {
        ArrayList<String> parentGroups = subgroup.getParentGroups();
        if (parentGroups == null) {
            parentGroups = new ArrayList<String>();
        }
        if (!parentGroups.contains(groupName)) {
            parentGroups.add(groupName);
            subgroup.setParentGroups(parentGroups);
            ((UserManager)Framework.getService(UserManager.class)).updateGroup(subgroup.getModel());
        }
    }

    public static void removeUserFromGroup(NuxeoPrincipal principal, NuxeoGroup group) {
        UserManagerHelper.removeUserFromGroup(principal, group, false);
    }

    public static void removeUserFromGroup(NuxeoPrincipal principal, NuxeoGroup group, boolean loadGroupMembers) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        String groupName = group.getName();
        if (!BaseSession.isReadOnlyEntry((DocumentModel)principal.getModel())) {
            ArrayList groups = principal.getGroups();
            if (groups == null) {
                groups = new ArrayList();
            }
            if (groups.contains(groupName)) {
                groups.remove(groupName);
                principal.setGroups(groups);
                userManager.updateUser(principal.getModel());
            }
        } else {
            String userName;
            ArrayList users;
            if (loadGroupMembers) {
                group = userManager.getGroup(groupName);
            }
            if ((users = group.getMemberUsers()) == null) {
                users = new ArrayList();
            }
            if (users.contains(userName = principal.getName())) {
                users.remove(userName);
                group.setMemberUsers(users);
                userManager.updateGroup(group.getModel());
            }
        }
    }

    public static void removeGroupFromGroup(NuxeoGroup subgroup, String groupName) {
        ArrayList parentGroups = subgroup.getParentGroups();
        if (parentGroups == null) {
            parentGroups = new ArrayList();
        }
        if (parentGroups.contains(groupName)) {
            parentGroups.remove(groupName);
            subgroup.setParentGroups(parentGroups);
            ((UserManager)Framework.getService(UserManager.class)).updateGroup(subgroup.getModel());
        }
    }
}

