/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractGroupMemberPageProvider<T>
extends AbstractPageProvider<T>
implements PageProvider<T> {
    private static final long serialVersionUID = 1L;
    protected UserManager userManager;
    protected List<T> currentPage;

    protected static int safeLongToInt(long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(l + " cannot be cast to int without changing its value.");
        }
        return (int)l;
    }

    public List<T> getCurrentPage() {
        if (this.currentPage == null) {
            int limit;
            this.currentPage = new ArrayList<T>();
            NuxeoGroup group = (NuxeoGroup)this.getParameters()[0];
            String query = null;
            if (this.getParameters().length > 1) {
                query = (String)this.getParameters()[1];
            }
            List<String> members = this.getMembers(group);
            if (StringUtils.isNotEmpty((CharSequence)query) && !"*".equals(query)) {
                query = query.toLowerCase();
                Iterator<String> it = members.iterator();
                while (it.hasNext()) {
                    if (it.next().toLowerCase().startsWith(query)) continue;
                    it.remove();
                }
            }
            if ((limit = AbstractGroupMemberPageProvider.safeLongToInt(this.getCurrentPageOffset() + this.getPageSize())) > members.size()) {
                limit = members.size();
            }
            for (String member : members.subList(AbstractGroupMemberPageProvider.safeLongToInt(this.getCurrentPageOffset()), limit)) {
                T object = this.getMember(member);
                if (object == null) continue;
                this.currentPage.add(object);
            }
            this.setResultsCount(members.size());
        }
        return this.currentPage;
    }

    protected abstract List<String> getMembers(NuxeoGroup var1);

    protected abstract T getMember(String var1);

    public long getPageLimit() {
        long pageSize = this.getPageSize();
        if (pageSize == 0L) {
            return 0L;
        }
        return (long)((NuxeoGroup)this.getParameters()[0]).getMemberGroups().size() / pageSize;
    }

    public boolean isSortable() {
        return false;
    }

    protected void pageChanged() {
        this.currentPage = null;
        super.pageChanged();
    }

    protected UserManager getUserManager() {
        if (this.userManager == null) {
            this.userManager = (UserManager)Framework.getService(UserManager.class);
        }
        return this.userManager;
    }
}

