/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager.io;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class NuxeoPrincipalJsonReader
extends EntityJsonReader<NuxeoPrincipal> {
    @Inject
    private UserManager userManager;

    public NuxeoPrincipalJsonReader() {
        super("user");
    }

    protected NuxeoPrincipal readEntity(JsonNode jn) throws IOException {
        JsonNode propsNode;
        NuxeoPrincipal principal;
        String id = this.getStringField(jn, "id");
        DocumentModel userDoc = null;
        if (id != null && (principal = this.userManager.getPrincipal(id)) != null) {
            userDoc = principal.getModel();
        }
        if (userDoc == null) {
            userDoc = this.userManager.getBareUserModel();
        }
        if ((propsNode = jn.get("properties")) != null && !propsNode.isNull() && propsNode.isObject()) {
            ParameterizedType genericType = TypeUtils.parameterize(List.class, (Type[])new Type[]{Property.class});
            String schema = this.userManager.getUserSchemaName();
            try (Closeable resource = this.ctx.wrap().with("DEFAULT_SCHEMA_NAME", (Object)schema).open();){
                List properties = (List)this.readEntity(List.class, genericType, propsNode);
                for (Property property : properties) {
                    userDoc.setPropertyValue(property.getName(), property.getValue());
                }
            }
        }
        NuxeoPrincipalImpl principal2 = new NuxeoPrincipalImpl(id);
        principal2.setModel(userDoc);
        return principal2;
    }
}

