/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.directory.mongodb;

import com.mongodb.MongoWriteException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.nuxeo.directory.mongodb.MongoDBDirectory;
import org.nuxeo.directory.mongodb.MongoDBReference;
import org.nuxeo.directory.mongodb.MongoDBSerializationHelper;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBAbstractQueryBuilder;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBConverter;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.OperationNotAllowedException;
import org.nuxeo.ecm.directory.PasswordHelper;
import org.nuxeo.ecm.directory.Session;

public class MongoDBSession
extends BaseSession {
    private static final Logger log = LogManager.getLogger(MongoDBSession.class);

    public MongoDBSession(MongoDBDirectory directory) {
        super((Directory)directory, MongoDBReference.class);
    }

    public MongoDBDirectory getDirectory() {
        return (MongoDBDirectory)this.directory;
    }

    public DocumentModel getEntryFromSource(String id, boolean fetchReferences) {
        String idFieldName = this.getPrefixedIdField();
        DocumentModelList result = this.doQuery(Collections.singletonMap(idFieldName, id), Collections.emptySet(), Collections.emptyMap(), fetchReferences, 1, 0, false);
        if (result.isEmpty()) {
            return null;
        }
        DocumentModel docModel = (DocumentModel)result.get(0);
        if (this.isMultiTenant() && !this.checkEntryTenantId((String)docModel.getProperty(this.schemaName, "tenantId"))) {
            return null;
        }
        return docModel;
    }

    protected DocumentModel createEntryWithoutReferences(Map<String, Object> fieldMap) {
        Object tenantId;
        String id;
        fieldMap = new HashMap<String, Object>(fieldMap);
        Map newDocMap = fieldMap.entrySet().stream().filter(entry -> this.getDirectory().getReferences((String)entry.getKey()) == null).collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), v.getValue()), HashMap::putAll);
        Map schemaFieldMap = this.directory.getSchemaFieldMap();
        String idFieldName = this.getPrefixedIdField();
        if (this.autoincrementId) {
            Document filter = MongoDBSerializationHelper.fieldMapToBson("_id", this.directoryName);
            Bson bson = Updates.inc((String)"seq", (Number)1L);
            FindOneAndUpdateOptions options = new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER);
            Long longId = ((Document)this.getCountersCollection().findOneAndUpdate((Bson)filter, bson, options)).getLong((Object)"seq");
            fieldMap.put(idFieldName, longId);
            newDocMap.put(idFieldName, longId);
            id = String.valueOf(longId);
        } else {
            Object rawId = fieldMap.get(idFieldName);
            if (rawId == null) {
                throw new DirectoryException("Missing id");
            }
            id = String.valueOf(rawId);
            if (StringUtils.isBlank((CharSequence)id)) {
                throw new DirectoryException("Missing id");
            }
        }
        if (this.isMultiTenant() && StringUtils.isNotBlank((CharSequence)(tenantId = this.getCurrentTenantId()))) {
            fieldMap.put("tenantId", tenantId);
            newDocMap.put("tenantId", tenantId);
            if (this.computeMultiTenantId) {
                id = MongoDBSession.computeMultiTenantDirectoryId((String)tenantId, (String)id);
                fieldMap.put(idFieldName, id);
                newDocMap.put(idFieldName, id);
            }
        }
        if (this.hasEntry0(id)) {
            throw new DirectoryException(String.format("Entry with id %s already exists in directory %s", id, this.directory.getName()), 409);
        }
        try {
            for (Map.Entry entry2 : schemaFieldMap.entrySet()) {
                Field field = (Field)entry2.getValue();
                if (field == null) continue;
                String fieldName = field.getName().getPrefixedName();
                Type type = field.getType();
                newDocMap.computeIfPresent(fieldName, (k, v) -> this.convertToType(v, type));
                Object defaultValue = field.getDefaultValue();
                if (defaultValue == null) continue;
                newDocMap.putIfAbsent(fieldName, defaultValue);
            }
            Document bson = MongoDBSerializationHelper.fieldMapToBson(newDocMap);
            String string = (String)newDocMap.get(this.getPrefixedPasswordField());
            if (string != null && !PasswordHelper.isHashed((String)string)) {
                String string2 = PasswordHelper.hashPassword((String)string, (String)this.passwordHashAlgorithm);
                bson.append(this.getPrefixedPasswordField(), (Object)string2);
            }
            this.getCollection().insertOne((Object)bson);
        }
        catch (MongoWriteException e) {
            throw new DirectoryException((Throwable)e);
        }
        return MongoDBSession.createEntryModel(null, (String)this.schemaName, (String)String.valueOf(fieldMap.get(idFieldName)), fieldMap, (boolean)this.isReadOnly());
    }

    protected Object convertToType(Object value, Type type) {
        Object result = value;
        if (value instanceof String) {
            if (type instanceof IntegerType) {
                result = Integer.valueOf((String)value);
            } else if (type instanceof LongType) {
                result = Long.valueOf((String)value);
            }
        } else if (value instanceof Number) {
            if (type instanceof LongType && value instanceof Integer) {
                result = (long)((Integer)value).intValue();
            } else if (type instanceof StringType) {
                result = value.toString();
            }
        }
        return result;
    }

    protected List<String> updateEntryWithoutReferences(DocumentModel docModel) {
        String entryTenantId;
        String tenantId;
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        LinkedList<String> referenceFieldList = new LinkedList<String>();
        if (this.isMultiTenant() && StringUtils.isNotBlank((CharSequence)(tenantId = this.getCurrentTenantId())) && (StringUtils.isBlank((CharSequence)(entryTenantId = (String)docModel.getProperty(this.schemaName, "tenantId"))) || !entryTenantId.equals(tenantId))) {
            throw new OperationNotAllowedException("Operation not allowed in the current tenant context", "label.directory.error.multi.tenant.operationNotAllowed", null);
        }
        List fields = this.directory.getSchemaFieldMap().values().stream().map(field -> field.getName().getPrefixedName()).collect(Collectors.toList());
        String idFieldName = this.getPrefixedIdField();
        String passwordFieldName = this.getPrefixedPasswordField();
        for (String fieldName : fields) {
            Property prop;
            if (fieldName.equals(idFieldName) || (prop = docModel.getPropertyObject(this.schemaName, fieldName)) == null || !prop.isDirty() || fieldName.equals(passwordFieldName) && StringUtils.isEmpty((CharSequence)((String)((Object)prop.getValue())))) continue;
            if (this.getDirectory().isReference(fieldName)) {
                referenceFieldList.add(fieldName);
                continue;
            }
            Object value = prop.getValue();
            if (fieldName.equals(passwordFieldName)) {
                value = PasswordHelper.hashPassword((String)((String)value), (String)this.passwordHashAlgorithm);
            }
            if (value instanceof Calendar) {
                value = ((Calendar)value).getTime();
            }
            fieldMap.put(prop.getName(), value);
        }
        String id = docModel.getId();
        Object idFieldValue = this.convertToType(id, this.getIdFieldType());
        Document bson = MongoDBSerializationHelper.fieldMapToBson(idFieldName, idFieldValue);
        List updates = fieldMap.entrySet().stream().map(e -> Updates.set((String)((String)e.getKey()), e.getValue())).collect(Collectors.toList());
        if (!updates.isEmpty()) {
            try {
                UpdateResult result = this.getCollection().updateOne((Bson)bson, Updates.combine(updates));
                if (!result.wasAcknowledged()) {
                    throw new DirectoryException("Error while updating the entry, the request has not been acknowledged by the server");
                }
                if (result.getMatchedCount() == 0L) {
                    throw new DirectoryException(String.format("Error while updating the entry, no document was found with the id %s", id));
                }
            }
            catch (MongoWriteException e2) {
                throw new DirectoryException((Throwable)e2);
            }
        }
        return referenceFieldList;
    }

    public void deleteEntryWithoutReferences(String id) {
        try {
            String idFieldName = this.getPrefixedIdField();
            Object idFieldValue = this.convertToType(id, this.getIdFieldType());
            DeleteResult result = this.getCollection().deleteOne((Bson)MongoDBSerializationHelper.fieldMapToBson(idFieldName, idFieldValue));
            if (!result.wasAcknowledged()) {
                throw new DirectoryException("Error while deleting the entry, the request has not been acknowledged by the server");
            }
        }
        catch (MongoWriteException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences, int limit, int offset) {
        return this.doQuery(filter, fulltext, orderBy, fetchReferences, limit, offset, true);
    }

    protected DocumentModelList doQuery(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences, int limit, int offset, boolean checkTenantId) {
        String tenantId;
        if (!this.hasPermission("Read")) {
            return new DocumentModelListImpl();
        }
        HashMap<String, Serializable> filterMap = new HashMap<String, Serializable>(filter);
        if (checkTenantId && this.isMultiTenant() && StringUtils.isNotBlank((CharSequence)(tenantId = this.getCurrentTenantId()))) {
            filterMap.put("tenantId", (Serializable)((Object)tenantId));
        }
        String passwordFieldName = this.getPrefixedPasswordField();
        filterMap.remove(passwordFieldName);
        Document bson = this.buildQuery(filterMap, fulltext);
        DocumentModelListImpl entries = new DocumentModelListImpl();
        log.error("NPS:  -> 1Reading entity {} in collection {}", filter.values(), (Object)this.getCollection().getNamespace().getCollectionName());
        FindIterable results = this.getCollection().find((Bson)bson).skip(offset);
        if (limit > 0) {
            results.limit(limit);
        }
        for (Document resultDoc : results) {
            Map<String, Object> fieldMap = MongoDBSerializationHelper.bsonToFieldMap(resultDoc);
            if (!this.readAllColumns) {
                fieldMap.remove(passwordFieldName);
            }
            DocumentModel doc = this.fieldMapToDocumentModel(fieldMap);
            if (fetchReferences) {
                HashMap<String, List> targetIdsMap = new HashMap<String, List>();
                for (org.nuxeo.ecm.directory.Reference reference : this.directory.getReferences()) {
                    List<String> targetIds;
                    if (reference instanceof MongoDBReference) {
                        MongoDBReference mongoReference = (MongoDBReference)reference;
                        targetIds = mongoReference.getTargetIdsForSource(doc.getId(), this);
                    } else {
                        targetIds = reference.getTargetIdsForSource(doc.getId());
                    }
                    targetIds = new ArrayList<String>(targetIds);
                    Collections.sort(targetIds);
                    String fieldName = reference.getFieldName();
                    targetIdsMap.computeIfAbsent(fieldName, key -> new ArrayList()).addAll(targetIds);
                }
                for (Map.Entry entry : targetIdsMap.entrySet()) {
                    String fieldName = (String)entry.getKey();
                    List targetIds = (List)entry.getValue();
                    try {
                        doc.setProperty(this.schemaName, fieldName, (Object)targetIds);
                    }
                    catch (PropertyException e) {
                        throw new DirectoryException((Throwable)e);
                    }
                }
            }
            entries.add((Object)doc);
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            this.getDirectory().orderEntries((List)entries, orderBy);
        }
        return entries;
    }

    protected Document buildQuery(Map<String, Serializable> fieldMap, Set<String> fulltext) {
        Map schemaFieldMap = this.directory.getSchemaFieldMap();
        Document bson = new Document();
        for (Map.Entry<String, Serializable> entry : fieldMap.entrySet()) {
            Field field = schemaFieldMap.values().stream().filter(v -> v.getName().getPrefixedName().equals(entry.getKey())).findFirst().orElse(null);
            Serializable v2 = entry.getValue();
            Object value = field != null ? MongoDBSerializationHelper.valueToBson(v2, field.getType()) : MongoDBSerializationHelper.valueToBson(v2);
            String key = entry.getKey();
            if (fulltext != null && fulltext.contains(key)) {
                String val = String.valueOf(value);
                val = val.replaceAll("%+", ".*");
                switch (this.substringMatchType) {
                    case subany: {
                        this.addField(bson, key, Pattern.compile(val, 2));
                        break;
                    }
                    case subinitial: {
                        this.addField(bson, key, Pattern.compile("^" + val, 2));
                        break;
                    }
                    case subfinal: {
                        this.addField(bson, key, Pattern.compile(val + "$", 2));
                    }
                }
                continue;
            }
            this.addField(bson, key, value);
        }
        return bson;
    }

    protected void addField(Document bson, String key, Object value) {
        String keyFieldName = key;
        Field field = (Field)this.directory.getSchemaFieldMap().get(key);
        if (field != null) {
            keyFieldName = field.getName().getPrefixedName();
        }
        bson.put(keyFieldName, value);
    }

    public DocumentModelList query(QueryBuilder queryBuilder, boolean fetchReferences) {
        if (!this.hasPermission("Read")) {
            return new DocumentModelListImpl();
        }
        String passwordFieldName = this.getPrefixedPasswordField();
        if (BaseSession.FieldDetector.hasField((MultiExpression)queryBuilder.predicate(), (String)this.getPasswordField()) || BaseSession.FieldDetector.hasField((MultiExpression)queryBuilder.predicate(), (String)passwordFieldName)) {
            throw new DirectoryException("Cannot filter on password");
        }
        queryBuilder = this.addTenantId(queryBuilder);
        MongoDBConverter converter = new MongoDBConverter();
        MongoDBDirectoryQueryBuilder builder = new MongoDBDirectoryQueryBuilder(converter, (Expression)queryBuilder.predicate());
        builder.walk();
        Document filter = builder.getQuery();
        int limit = Math.max(0, (int)queryBuilder.limit());
        int offset = Math.max(0, (int)queryBuilder.offset());
        boolean countTotal = queryBuilder.countTotal();
        Document sort = builder.walkOrderBy(queryBuilder.orders());
        DocumentModelListImpl entries = new DocumentModelListImpl();
        log.error("NPS:  -> 2Reading entity {} in collection '{}'", (Object)filter.values(), (Object)this.getCollection().getNamespace().getCollectionName());
        try (MongoCursor cursor = this.getCollection().find((Bson)filter).limit(limit).skip(offset).sort((Bson)sort).iterator();){
            for (Document doc : () -> cursor) {
                if (!this.readAllColumns) {
                    doc.remove((Object)passwordFieldName);
                }
                State state = converter.bsonToState(doc);
                HashMap<String, Object> fieldMap = new HashMap<String, Object>();
                for (Map.Entry es : state.entrySet()) {
                    fieldMap.put((String)es.getKey(), es.getValue());
                }
                DocumentModel docModel = this.fieldMapToDocumentModel(fieldMap);
                if (fetchReferences) {
                    log.error("NPS:  -> Fetching references for {}", (Object)docModel.getId());
                    HashMap<String, List> targetIdsMap = new HashMap<String, List>();
                    for (org.nuxeo.ecm.directory.Reference reference : this.directory.getReferences()) {
                        List<String> targetIds;
                        if (reference instanceof MongoDBReference) {
                            MongoDBReference mongoReference = (MongoDBReference)reference;
                            targetIds = mongoReference.getTargetIdsForSource(docModel.getId(), this);
                        } else {
                            targetIds = reference.getTargetIdsForSource(docModel.getId());
                        }
                        targetIds = new ArrayList<String>(targetIds);
                        Collections.sort(targetIds);
                        String fieldName = reference.getFieldName();
                        targetIdsMap.computeIfAbsent(fieldName, key -> new ArrayList()).addAll(targetIds);
                    }
                    for (Map.Entry entry : targetIdsMap.entrySet()) {
                        String fieldName = (String)entry.getKey();
                        List targetIds = (List)entry.getValue();
                        docModel.setProperty(this.schemaName, fieldName, (Object)targetIds);
                    }
                }
                entries.add((Object)docModel);
            }
        }
        if (limit != 0 || offset != 0) {
            long count = countTotal ? this.getCollection().countDocuments((Bson)filter) : -2L;
            entries.setTotalSize(count);
        }
        return entries;
    }

    public List<String> queryIds(QueryBuilder queryBuilder) {
        if (!this.hasPermission("Read")) {
            return Collections.emptyList();
        }
        if (BaseSession.FieldDetector.hasField((MultiExpression)queryBuilder.predicate(), (String)this.getPasswordField()) || BaseSession.FieldDetector.hasField((MultiExpression)queryBuilder.predicate(), (String)this.getPrefixedPasswordField())) {
            throw new DirectoryException("Cannot filter on password");
        }
        queryBuilder = this.addTenantId(queryBuilder);
        MongoDBConverter converter = new MongoDBConverter();
        MongoDBDirectoryQueryBuilder builder = new MongoDBDirectoryQueryBuilder(converter, (Expression)queryBuilder.predicate());
        builder.walk();
        Document filter = builder.getQuery();
        String idFieldName = this.getPrefixedIdField();
        Document projection = new Document(idFieldName, (Object)1L);
        int limit = Math.max(0, (int)queryBuilder.limit());
        int offset = Math.max(0, (int)queryBuilder.offset());
        Document sort = builder.walkOrderBy(queryBuilder.orders());
        ArrayList<String> ids = new ArrayList<String>();
        try (MongoCursor cursor = this.getCollection().find((Bson)filter).projection((Bson)projection).limit(limit).skip(offset).sort((Bson)sort).iterator();){
            for (Document doc : () -> cursor) {
                State state = converter.bsonToState(doc);
                String id = this.getIdFromState(state);
                ids.add(id);
            }
        }
        return ids;
    }

    public void close() {
        this.getDirectory().removeSession((Session)this);
    }

    public boolean authenticate(String username, String password) {
        Document user = (Document)this.getCollection().find((Bson)MongoDBSerializationHelper.fieldMapToBson(this.getPrefixedIdField(), username)).first();
        if (user == null) {
            return false;
        }
        String storedPassword = user.getString((Object)this.getPrefixedPasswordField());
        if (this.isMultiTenant() && !this.checkEntryTenantId(user.getString((Object)"tenantId"))) {
            storedPassword = null;
        }
        return PasswordHelper.verifyPassword((String)password, (String)storedPassword);
    }

    public boolean isAuthenticating() {
        return this.directory.getSchemaFieldMap().containsKey(this.getPasswordField());
    }

    public boolean hasEntry(String id) {
        return this.hasEntry0(id);
    }

    protected boolean hasEntry0(Object id) {
        String idFieldName = this.getPrefixedIdField();
        Type idFieldType = this.getIdFieldType();
        Object idFieldValue = this.convertToType(id, idFieldType);
        return this.getCollection().countDocuments((Bson)MongoDBSerializationHelper.fieldMapToBson(idFieldName, idFieldValue)) > 0L;
    }

    protected MongoCollection<Document> getCollection() {
        return this.getDirectory().getCollection();
    }

    protected MongoCollection<Document> getCountersCollection() {
        return this.getDirectory().getCountersCollection();
    }

    protected DocumentModel fieldMapToDocumentModel(Map<String, Object> fieldMap) {
        String idFieldName = this.getPrefixedIdField();
        if (!fieldMap.containsKey(idFieldName)) {
            idFieldName = this.getIdField();
        }
        String id = String.valueOf(fieldMap.get(idFieldName));
        return MongoDBSession.createEntryModel(null, (String)this.schemaName, (String)id, fieldMap, (boolean)this.isReadOnly());
    }

    protected String getIdFromState(State state) {
        String idFieldName = this.getPrefixedIdField();
        if (!state.containsKey((Object)idFieldName)) {
            idFieldName = this.getIdField();
        }
        return String.valueOf(state.get((Object)idFieldName));
    }

    protected boolean checkEntryTenantId(String entryTenantId) {
        String tenantId = this.getCurrentTenantId();
        return StringUtils.isBlank((CharSequence)tenantId) || StringUtils.isBlank((CharSequence)entryTenantId) || tenantId.equals(entryTenantId);
    }

    protected String getPrefixedIdField() {
        Field idField = (Field)this.directory.getSchemaFieldMap().get(this.getIdField());
        if (idField == null) {
            return null;
        }
        return idField.getName().getPrefixedName();
    }

    protected String getPrefixedPasswordField() {
        Field passwordField = (Field)this.directory.getSchemaFieldMap().get(this.getPasswordField());
        if (passwordField == null) {
            return null;
        }
        return passwordField.getName().getPrefixedName();
    }

    protected Type getIdFieldType() {
        Field idField = (Field)this.directory.getSchemaFieldMap().get(this.getIdField());
        if (idField == null) {
            return null;
        }
        return idField.getType();
    }

    public class MongoDBDirectoryQueryBuilder
    extends MongoDBAbstractQueryBuilder {
        public MongoDBDirectoryQueryBuilder(MongoDBConverter converter, Expression expression) {
            super(converter, expression);
        }

        protected Document newDocumentWithField(MongoDBAbstractQueryBuilder.FieldInfo fieldInfo, Object value) {
            return new Document(fieldInfo.queryField, MongoDBSession.this.convertToType(value, fieldInfo.type));
        }

        protected MongoDBAbstractQueryBuilder.FieldInfo walkReference(String name) {
            Field field = (Field)MongoDBSession.this.directory.getSchemaFieldMap().get(name);
            if (field == null) {
                throw new QueryParseException("No column: " + name + " for directory: " + MongoDBSession.this.getDirectory().getName());
            }
            String key = field.getName().getPrefixedName();
            String queryField = this.stripElemMatchPrefix(key);
            return new MongoDBAbstractQueryBuilder.FieldInfo(name, key, queryField, queryField, field.getType());
        }

        protected Document walkOrderBy(OrderByList orderByList) {
            if (orderByList.isEmpty()) {
                return null;
            }
            Document orderBy = new Document();
            for (OrderByExpr ob : orderByList) {
                String field = this.walkReference((Reference)ob.reference).queryField;
                if (orderBy.containsKey((Object)field)) continue;
                orderBy.put(field, (Object)(ob.isDescending ? MINUS_ONE : ONE));
            }
            return orderBy;
        }
    }
}

