/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.cache.AbstractCache;
import org.nuxeo.ecm.core.cache.CacheDescriptor;

public class InMemoryCacheImpl
extends AbstractCache {
    private static final Logger log = LogManager.getLogger(InMemoryCacheImpl.class);
    protected final Cache<String, Serializable> cache;

    public InMemoryCacheImpl(CacheDescriptor desc) {
        super(desc);
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder = builder.expireAfterWrite(desc.getTTL(), TimeUnit.MINUTES);
        Map<String, String> options = desc.options;
        if (options.containsKey("concurrencyLevel")) {
            builder = builder.concurrencyLevel(Integer.parseInt(options.get("concurrencyLevel")));
        }
        if (options.containsKey("maxSize")) {
            builder = builder.maximumSize((long)Integer.parseInt(options.get("maxSize")));
        }
        this.cache = builder.build();
    }

    @Override
    public Serializable get(String key) {
        if (key == null) {
            return null;
        }
        return (Serializable)this.cache.getIfPresent((Object)key);
    }

    @Override
    public Set<String> keySet() {
        return this.cache.asMap().keySet();
    }

    @Override
    public void invalidate(String key) {
        this.invalidateLocal(key);
    }

    @Override
    public void invalidateLocal(String key) {
        log.error("Who invalidates key={} in {}", (Object)key, (Object)this.name, (Object)new Exception());
        if (key != null) {
            this.cache.invalidate((Object)key);
        } else {
            log.warn("Can't invalidate a null key for the cache: {}!", (Object)this.name);
        }
    }

    @Override
    public void invalidateAll() {
        this.invalidateLocalAll();
    }

    @Override
    public void invalidateLocalAll() {
        log.error("Who invalidates all in {}", (Object)this.name, (Object)new Exception());
        this.cache.invalidateAll();
    }

    @Override
    public void put(String key, Serializable value) {
        this.putLocal(key, value);
    }

    @Override
    public void putLocal(String key, Serializable value) {
        if (key != null && value != null) {
            this.cache.put((Object)key, (Object)value);
        } else {
            log.warn("Can't put a null key nor a null value in the cache: {}!", (Object)this.name);
        }
    }

    @Override
    public boolean hasEntry(String key) {
        return this.cache.asMap().containsKey(key);
    }

    @Override
    public long getSize() {
        return this.cache.size();
    }
}

