/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.transientstore;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.transientstore.AbstractTransientStore;
import org.nuxeo.ecm.core.transientstore.StorageEntry;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreConfig;

public class SimpleTransientStore
extends AbstractTransientStore {
    private static final Logger log = LogManager.getLogger(SimpleTransientStore.class);
    protected Cache<String, Serializable> l1Cache;
    protected Cache<String, Serializable> l2Cache;
    protected AtomicLong storageSize = new AtomicLong(0L);

    @Override
    public void init(TransientStoreConfig config) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = config::getName;
        log.debug("Initializing SimpleTransientStore: {}", supplierArray);
        super.init(config);
        this.l1Cache = CacheBuilder.newBuilder().expireAfterWrite((long)config.getFirstLevelTTL(), TimeUnit.MINUTES).build();
        this.l2Cache = CacheBuilder.newBuilder().expireAfterWrite((long)config.getSecondLevelTTL(), TimeUnit.MINUTES).build();
    }

    @Override
    public void shutdown() {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.config::getName;
        log.debug("Shutting down SimpleTransientStore: {}", supplierArray);
    }

    @Override
    public boolean exists(String key) {
        return this.getL1Cache().getIfPresent((Object)key) != null || this.getL2Cache().getIfPresent((Object)key) != null;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.getL1Cache().asMap().keySet());
        keys.addAll(this.getL2Cache().asMap().keySet());
        return keys;
    }

    @Override
    public Stream<String> keyStream() {
        return this.keySet().stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putParameter(String key, String parameter, Serializable value) {
        SimpleTransientStore simpleTransientStore = this;
        synchronized (simpleTransientStore) {
            StorageEntry entry = this.getStorageEntry(key);
            if (entry == null) {
                entry = new StorageEntry();
            }
            entry.putParam(parameter, value);
            log.debug("Setting parameter: {} to value: {} in StorageEntry stored at key: {}", (Object)parameter, (Object)value, (Object)key);
            this.putStorageEntry(key, entry);
        }
    }

    @Override
    public Serializable getParameter(String key, String parameter) {
        StorageEntry entry = this.getStorageEntry(key);
        if (entry == null) {
            return null;
        }
        Serializable res = entry.getParam(parameter);
        log.debug("Fetched parameter: {} from StorageEntry stored at key {}: {}", (Object)parameter, (Object)key, (Object)res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putParameters(String key, Map<String, Serializable> parameters) {
        SimpleTransientStore simpleTransientStore = this;
        synchronized (simpleTransientStore) {
            StorageEntry entry = this.getStorageEntry(key);
            if (entry == null) {
                entry = new StorageEntry();
            }
            entry.putParams(parameters);
            log.debug("Setting parameters: {} in StorageEntry stored at key: {}", parameters, (Object)key);
            this.putStorageEntry(key, entry);
        }
    }

    @Override
    public Map<String, Serializable> getParameters(String key) {
        StorageEntry entry = this.getStorageEntry(key);
        if (entry == null) {
            return null;
        }
        HashMap<String, Serializable> res = new HashMap<String, Serializable>(entry.getParams());
        log.debug("Fetched parameters from StorageEntry stored at key {}: {}", (Object)key, res);
        return res;
    }

    @Override
    public List<Blob> getBlobs(String key) {
        StorageEntry entry = this.getStorageEntry(key);
        if (entry == null) {
            return null;
        }
        List<Map<String, String>> blobInfos = entry.getBlobInfos();
        if (blobInfos == null) {
            return new ArrayList<Blob>();
        }
        return this.loadBlobs(blobInfos);
    }

    @Override
    public long getSize(String key) {
        StorageEntry entry = this.getStorageEntry(key);
        if (entry == null) {
            return -1L;
        }
        long size = entry.getSize();
        log.debug("Fetched field \"size\" from StorageEntry stored at key {}: {}", (Object)key, (Object)size);
        return size;
    }

    @Override
    public boolean isCompleted(String key) {
        StorageEntry entry = this.getStorageEntry(key);
        boolean completed = entry != null && entry.isCompleted();
        log.debug("Fetched field \"completed\" from StorageEntry stored at key {}: {}", (Object)key, (Object)completed);
        return completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCompleted(String key, boolean completed) {
        SimpleTransientStore simpleTransientStore = this;
        synchronized (simpleTransientStore) {
            StorageEntry entry = this.getStorageEntry(key);
            if (entry == null) {
                entry = new StorageEntry();
            }
            entry.setCompleted(completed);
            log.debug("Setting field \"completed\" to value: {} in StorageEntry stored at key: {}", (Object)completed, (Object)key);
            this.putStorageEntry(key, entry);
        }
    }

    @Override
    public void release(String key) {
        StorageEntry entry = (StorageEntry)this.getL1Cache().getIfPresent((Object)key);
        if (entry != null) {
            log.debug("Invalidating StorageEntry stored at key: {} form L1 cache", (Object)key);
            this.getL1Cache().invalidate((Object)key);
            if (this.getStorageSize() <= (long)(this.config.getTargetMaxSizeMB() * 0x100000) || this.config.getTargetMaxSizeMB() < 0) {
                log.debug("Putting StorageEntry at key: {} in L2 cache", (Object)key);
                this.getL2Cache().put((Object)key, (Object)entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void persistBlobs(String key, long sizeOfBlobs, List<Map<String, String>> blobInfos) {
        SimpleTransientStore simpleTransientStore = this;
        synchronized (simpleTransientStore) {
            StorageEntry entry = this.getStorageEntry(key);
            if (entry == null) {
                if (sizeOfBlobs > 0L) {
                    this.incrementStorageSize(sizeOfBlobs);
                }
                entry = new StorageEntry();
            } else {
                this.incrementStorageSize(sizeOfBlobs - entry.getSize());
            }
            entry.setSize(sizeOfBlobs);
            entry.setBlobInfos(blobInfos);
            log.debug("Setting blobs: {} in StorageEntry stored at key: {}", blobInfos, (Object)key);
            this.putStorageEntry(key, entry);
        }
    }

    @Override
    public long getStorageSize() {
        long size = this.storageSize.get();
        log.debug("Fetched storage size of store {}: {}", (Object)this.config.getName(), (Object)size);
        return size;
    }

    @Override
    protected void setStorageSize(long newSize) {
        log.debug("Setting storage size of store: {} to: {}", (Object)this.config.getName(), (Object)newSize);
        this.storageSize.set(newSize);
    }

    @Override
    protected long incrementStorageSize(long size) {
        long incremented = this.storageSize.addAndGet(size);
        log.debug("Incremented storage size of store: {} to: {}", (Object)this.config.getName(), (Object)incremented);
        return incremented;
    }

    @Override
    protected long decrementStorageSize(long size) {
        long decremented = this.storageSize.addAndGet(-size);
        log.debug("Decremented storage size of store: {} to: {}", (Object)this.config.getName(), (Object)decremented);
        return decremented;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeEntry(String key) {
        SimpleTransientStore simpleTransientStore = this;
        synchronized (simpleTransientStore) {
            long entrySize;
            StorageEntry entry = (StorageEntry)this.getL1Cache().getIfPresent((Object)key);
            if (entry == null) {
                entry = (StorageEntry)this.getL2Cache().getIfPresent((Object)key);
                log.debug("Invalidating StorageEntry stored at key: {} form L2 cache", (Object)key);
                this.getL2Cache().invalidate((Object)key);
            } else {
                log.debug("Invalidating StorageEntry stored at key: {} form L1 cache", (Object)key);
                this.getL1Cache().invalidate((Object)key);
            }
            if (entry != null && (entrySize = entry.getSize()) > 0L) {
                this.decrementStorageSize(entrySize);
            }
        }
    }

    @Override
    protected void removeAllEntries() {
        log.debug("Invalidating all entries from L1 and L2 caches");
        this.getL1Cache().invalidateAll();
        this.getL2Cache().invalidateAll();
    }

    public Cache<String, Serializable> getL1Cache() {
        return this.l1Cache;
    }

    public Cache<String, Serializable> getL2Cache() {
        return this.l2Cache;
    }

    protected StorageEntry getStorageEntry(String key) {
        StorageEntry entry = (StorageEntry)this.getL1Cache().getIfPresent((Object)key);
        if (entry == null) {
            entry = (StorageEntry)this.getL2Cache().getIfPresent((Object)key);
        }
        return entry;
    }

    protected void putStorageEntry(String key, StorageEntry entry) {
        this.getL1Cache().put((Object)key, (Object)entry);
    }
}

