/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.computedgroups;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.computedgroups.AbstractGroupComputer;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;

public abstract class AbstractAttributeBasedGroupComputer
extends AbstractGroupComputer {
    protected abstract String getAttributeForGroupComputation();

    @Override
    public List<String> getAllGroupIds() {
        ArrayList<String> companies = new ArrayList<String>();
        for (String userId : this.getUM().getUserIds()) {
            String companyName;
            DocumentModel doc = this.getUM().getUserModel(userId);
            if (doc == null || companies.contains(companyName = (String)doc.getProperty(this.getUM().getUserSchemaName(), this.getAttributeForGroupComputation()))) continue;
            companies.add(companyName);
        }
        return companies;
    }

    @Override
    public List<String> getGroupMembers(String groupName) {
        HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
        filter.put(this.getAttributeForGroupComputation(), (Serializable)((Object)groupName));
        DocumentModelList users = this.getUM().searchUsers(filter, null);
        ArrayList<String> memberIds = new ArrayList<String>();
        for (DocumentModel user : users) {
            memberIds.add(user.getId());
        }
        return memberIds;
    }

    @Override
    public List<String> getGroupsForUser(NuxeoPrincipalImpl nuxeoPrincipal) {
        ArrayList<String> grpNames = new ArrayList<String>();
        String property = (String)nuxeoPrincipal.getModel().getProperty(this.getUM().getUserSchemaName(), this.getAttributeForGroupComputation());
        if (property != null && !"".equals(property.trim())) {
            grpNames.add(property);
        }
        return grpNames;
    }

    @Override
    public List<String> getParentsGroupNames(String groupName) {
        return null;
    }

    @Override
    public List<String> getSubGroupsNames(String groupName) {
        return null;
    }

    @Override
    public List<String> searchGroups(Map<String, Serializable> filter, Set<String> fulltext) {
        ArrayList<String> companies = new ArrayList<String>();
        String grpName = (String)((Object)filter.get(this.getUM().getGroupIdField()));
        if (grpName != null) {
            HashMap<String, Serializable> gFilter = new HashMap<String, Serializable>();
            HashSet<String> gFulltext = new HashSet<String>();
            gFilter.put(this.getAttributeForGroupComputation(), (Serializable)((Object)grpName));
            gFulltext.add(this.getAttributeForGroupComputation());
            for (DocumentModel userDoc : this.getUM().searchUsers(gFilter, gFulltext)) {
                String companyName = (String)userDoc.getProperty(this.getUM().getUserSchemaName(), this.getAttributeForGroupComputation());
                if (companies.contains(companyName)) continue;
                companies.add(companyName);
            }
        }
        return companies;
    }
}

