/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.transientstore;

import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.runtime.api.Framework;

public class TransiantStorageGCWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    protected final String store;
    public static final String CATEGORY = "transientStorageGC";

    public TransiantStorageGCWork(String store) {
        super(store);
        this.store = store;
    }

    public boolean isIdempotent() {
        return false;
    }

    public String getTitle() {
        return "Transient Store GC" + (String)(this.store != null ? " on " + this.store : "");
    }

    public String getCategory() {
        return CATEGORY;
    }

    public void work() {
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        if (this.store != null) {
            tss.doGC(this.store);
        } else {
            tss.doGC();
        }
    }
}

