/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.computedgroups;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.platform.computedgroups.ComputedGroup;
import org.nuxeo.ecm.platform.computedgroups.ComputedGroupsService;
import org.nuxeo.ecm.platform.usermanager.GroupConfig;
import org.nuxeo.runtime.api.Framework;

public class NuxeoComputedGroup
implements ComputedGroup {
    private static final long serialVersionUID = 1L;
    protected List<String> members;
    protected List<String> subGroups;
    protected List<String> parents;
    protected DocumentModel model;
    protected GroupConfig config = GroupConfig.DEFAULT;

    public NuxeoComputedGroup(String name, GroupConfig config) {
        this(name, null, config);
    }

    public NuxeoComputedGroup(String name, String label, GroupConfig config) {
        this.config = config;
        this.model = SimpleDocumentModel.empty();
        this.model.setProperty(config.schemaName, config.idField, (Object)name);
        this.model.setProperty(config.schemaName, config.labelField, (Object)label);
    }

    public List<String> getMemberUsers() {
        if (this.members == null) {
            ComputedGroupsService cgs = (ComputedGroupsService)Framework.getService(ComputedGroupsService.class);
            if (cgs != null) {
                this.members = cgs.getComputedGroupMembers(this.getName());
            }
            if (this.members == null) {
                this.members = new ArrayList<String>();
            }
            this.model.setProperty(this.config.schemaName, this.config.membersField, this.members);
        }
        return this.members;
    }

    public String getName() {
        return (String)this.model.getProperty(this.config.schemaName, this.config.idField);
    }

    public String getLabel() {
        String label = (String)this.model.getProperty(this.config.schemaName, this.config.labelField);
        return label == null ? this.getName() : label;
    }

    public List<String> getParentGroups() {
        if (this.parents == null) {
            ComputedGroupsService cgs = (ComputedGroupsService)Framework.getService(ComputedGroupsService.class);
            if (cgs != null) {
                this.parents = cgs.getComputedGroupParent(this.getName());
            }
            if (this.parents == null) {
                this.parents = new ArrayList<String>();
            }
            this.model.setProperty(this.config.schemaName, this.config.parentGroupsField, this.parents);
        }
        return this.parents;
    }

    public List<String> getMemberGroups() {
        if (this.subGroups == null) {
            ComputedGroupsService cgs = (ComputedGroupsService)Framework.getService(ComputedGroupsService.class);
            if (cgs != null) {
                this.subGroups = cgs.getComputedGroupSubGroups(this.getName());
            }
            if (this.subGroups == null) {
                this.subGroups = new ArrayList<String>();
            }
            this.model.setProperty(this.config.schemaName, this.config.subGroupsField, this.subGroups);
        }
        return this.subGroups;
    }

    public void setMemberGroups(List<String> groups) {
        throw new UnsupportedOperationException("Computed groups are read only");
    }

    public void setMemberUsers(List<String> users) {
        throw new UnsupportedOperationException("Computed groups are read only");
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("Computed groups are read only");
    }

    public void setLabel(String label) {
        throw new UnsupportedOperationException("Computed groups are read only");
    }

    public void setParentGroups(List<String> groups) {
        throw new UnsupportedOperationException("Computed groups are read only");
    }

    public DocumentModel getModel() {
        return this.model;
    }
}

