/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.cache.CacheManagement;
import org.nuxeo.ecm.core.cache.CacheServiceImpl;
import org.nuxeo.ecm.core.cache.CacheWrapper;

public class CacheInvalidator
extends CacheWrapper {
    private static final Logger log = LogManager.getLogger(CacheInvalidator.class);
    protected final CacheServiceImpl.CachePubSubInvalidator invalidator;

    public CacheInvalidator(CacheManagement cache, CacheServiceImpl.CachePubSubInvalidator invalidator) {
        super(cache);
        this.invalidator = invalidator;
    }

    @Override
    public void put(String key, Serializable value) {
        super.put(key, value);
        log.error("NPS: send invalidation for cache={} on PUT {}", (Object)this.getName(), (Object)key, (Object)new Exception());
        this.invalidator.sendInvalidation(this.getName(), key);
    }

    @Override
    public void invalidate(String key) {
        super.invalidate(key);
        log.error("NPS: send invalidation for cache={} on INVALIDATE {}", (Object)this.getName(), (Object)key, (Object)new Exception());
        this.invalidator.sendInvalidation(this.getName(), key);
    }

    @Override
    public void invalidateAll() {
        super.invalidateAll();
        log.error("NPS: send invalidation for cache={} on INVALIDATE ALL", (Object)this.getName(), (Object)new Exception());
        this.invalidator.sendInvalidationsAll(this.getName());
    }
}

