/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.providers;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByExprs;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryEntry;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;

public class DirectoryEntryPageProvider
extends AbstractPageProvider<DirectoryEntry> {
    private static final long serialVersionUID = 1L;

    public List<DirectoryEntry> getCurrentPage() {
        Object[] parameters = this.getParameters();
        if (parameters == null || parameters.length > 1) {
            throw new IllegalStateException("Invalid parameters: " + Arrays.toString(parameters));
        }
        if (!(parameters[0] instanceof Directory)) {
            throw new IllegalStateException("Provided parameter is not a Directory: " + String.valueOf(parameters[0]));
        }
        Directory directory = (Directory)parameters[0];
        try (Session session = directory.getSession();){
            List orders = this.getSortInfos().stream().map(this::toOrderExp).collect(Collectors.toList());
            DocumentModelList result = session.query(new QueryBuilder().orders(orders).limit(this.getPageSize()).offset(this.getCurrentPageOffset()).countTotal(true), false);
            this.setResultsCount(result.totalSize());
            List<DirectoryEntry> list = result.stream().map(dir -> new DirectoryEntry(directory.getName(), (DocumentModel)dir)).collect(Collectors.toList());
            return list;
        }
    }

    protected OrderByExpr toOrderExp(SortInfo sortInfo) {
        String sortColumn = sortInfo.getSortColumn();
        return sortInfo.getSortAscending() ? OrderByExprs.asc((String)sortColumn) : OrderByExprs.desc((String)sortColumn);
    }
}

