/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.scroll;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.nuxeo.ecm.core.api.scroll.Scroll;
import org.nuxeo.ecm.core.api.scroll.ScrollRequest;
import org.nuxeo.ecm.core.query.sql.SQLQueryParser;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByExprs;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.scroll.GenericScrollRequest;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.NuxeoLoginContext;

public class DirectoryScroll
implements Scroll {
    public static final String SCROLL_NAME = "directory";
    protected NuxeoLoginContext loginContext;
    protected Session session;
    protected long offset;
    protected int size;
    protected boolean hasNext;
    protected OrderByExpr orderBy;

    public void init(ScrollRequest request, Map<String, String> options) {
        if (!(request instanceof GenericScrollRequest)) {
            throw new IllegalArgumentException("Requires a GenericScrollRequest, got a " + request.getClass().getCanonicalName());
        }
        GenericScrollRequest scrollRequest = (GenericScrollRequest)request;
        this.offset = 0L;
        this.hasNext = true;
        this.size = scrollRequest.getSize();
        SQLQuery sqlQuery = SQLQueryParser.parse((String)scrollRequest.getQuery());
        if (sqlQuery.getFromClause().count() != 1) {
            throw new IllegalArgumentException("Invalid query:" + scrollRequest.getQuery());
        }
        String directoryName = sqlQuery.getFromClause().get(0);
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        this.orderBy = OrderByExprs.asc((String)ds.getDirectoryIdField(directoryName));
        this.loginContext = Framework.loginSystem();
        this.session = ds.open(directoryName);
    }

    public void close() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        if (this.loginContext != null) {
            this.loginContext.close();
            this.loginContext = null;
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public List<String> next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        QueryBuilder queryBuilder = new QueryBuilder().offset(this.offset).limit((long)(this.size + 1)).order(this.orderBy);
        this.offset += (long)this.size;
        List<String> entries = this.session.queryIds(queryBuilder);
        if (entries.size() <= this.size) {
            this.hasNext = false;
            return entries;
        }
        this.hasNext = true;
        return entries.subList(0, this.size);
    }
}

