/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.avro;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.io.avro.NonNullValueException;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.avro.AvroMapper;
import org.nuxeo.runtime.avro.AvroService;

public class BlobPropertyMapper
extends AvroMapper<BlobProperty, Object> {
    public BlobPropertyMapper(AvroService service) {
        super(service);
    }

    public Object fromAvro(Schema schema, Object input) {
        switch (schema.getType()) {
            case NULL: {
                if (input == null) {
                    return null;
                }
                throw new NonNullValueException();
            }
            case UNION: {
                for (Schema sub : schema.getTypes()) {
                    try {
                        return this.service.fromAvro(sub, BlobProperty.class, input);
                    }
                    catch (NonNullValueException nonNullValueException) {
                    }
                }
                throw new RuntimeServiceException("Cannot map from value " + schema.getType());
            }
            case RECORD: {
                try {
                    GenericRecord record = (GenericRecord)input;
                    String mimeType = (String)record.get(this.service.encodeName("mime-type"));
                    String encoding = (String)record.get("encoding");
                    byte[] bytes = ((ByteBuffer)record.get("data")).array();
                    Blob b = Blobs.createBlob((byte[])bytes, (String)mimeType, (String)encoding);
                    b.setFilename((String)record.get("name"));
                    b.setDigest((String)record.get("digest"));
                    return b;
                }
                catch (IOException e) {
                    throw new RuntimeServiceException("Cannot map from value " + schema.getType(), (Throwable)e);
                }
            }
        }
        throw new RuntimeServiceException("Cannot map from value " + schema.getType());
    }

    public Object toAvro(Schema schema, BlobProperty input) {
        switch (schema.getType()) {
            case NULL: {
                if (input == null) {
                    return null;
                }
                throw new NonNullValueException();
            }
            case UNION: {
                for (Schema s : schema.getTypes()) {
                    try {
                        return this.service.toAvro(s, (Object)input);
                    }
                    catch (NonNullValueException nonNullValueException) {
                    }
                }
                throw new RuntimeServiceException("Cannot map value to " + schema.getType());
            }
            case RECORD: {
                GenericData.Record record = new GenericData.Record(schema);
                for (Schema.Field f : schema.getFields()) {
                    if ("data".equals(f.name())) {
                        Blob blob = (Blob)input.getValue();
                        try {
                            record.put(f.name(), (Object)ByteBuffer.wrap(blob.getByteArray()));
                            continue;
                        }
                        catch (IOException e) {
                            throw new RuntimeServiceException("Cannot map value to " + schema.getType(), (Throwable)e);
                        }
                    }
                    record.put(f.name(), this.service.toAvro(f.schema(), (Object)input.get(this.service.decodeName(f.name()))));
                }
                return record;
            }
        }
        throw new RuntimeServiceException("Cannot map value to " + schema.getType());
    }
}

