/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.avro;

import java.util.ArrayList;
import org.apache.avro.Schema;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.runtime.avro.AvroSchemaFactory;
import org.nuxeo.runtime.avro.AvroSchemaFactoryContext;

public class ComplexTypeSchemaFactory
extends AvroSchemaFactory<ComplexType> {
    public ComplexTypeSchemaFactory(AvroSchemaFactoryContext context) {
        super(context);
    }

    public Schema createSchema(ComplexType input) {
        Schema schema = Schema.createRecord((String)this.getName(input), null, (String)input.getNamespace().prefix, (boolean)false);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>(input.getFields().size());
        for (Field f : this.context.sort(input.getFields())) {
            String fieldName = this.context.getService().encodeName(f.getName().getLocalName());
            Schema fieldSchema = this.context.createSchema((Object)f.getType());
            if (f.isNillable()) {
                fieldSchema = this.nullable(fieldSchema);
            }
            fields.add(new Schema.Field(fieldName, fieldSchema, null, null));
        }
        schema.setFields(fields);
        return schema;
    }

    public String getName(ComplexType input) {
        return this.context.getService().encodeName(input.getName());
    }

    public String getQualifiedName(ComplexType input) {
        return this.context.getService().encodeName(input.getNamespace().prefix) + ":" + this.getName(input);
    }
}

