/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.avro;

import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.commons.lang3.NotImplementedException;
import org.nuxeo.ecm.core.io.avro.ComplexTypeSchemaFactory;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.runtime.avro.AvroSchemaFactory;
import org.nuxeo.runtime.avro.AvroSchemaFactoryContext;

public class TypeSchemaFactory
extends AvroSchemaFactory<Type> {
    protected ComplexTypeSchemaFactory complexTypeFactory;

    public TypeSchemaFactory(AvroSchemaFactoryContext context) {
        super(context);
        this.complexTypeFactory = new ComplexTypeSchemaFactory(context);
    }

    public Schema createSchema(Type input) {
        if (input.isSimpleType()) {
            if (input == IntegerType.INSTANCE) {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            if (input == LongType.INSTANCE) {
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            if (input == DoubleType.INSTANCE) {
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            if (input == StringType.INSTANCE) {
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            if (input == BooleanType.INSTANCE) {
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            if (input == BinaryType.INSTANCE) {
                return Schema.create((Schema.Type)Schema.Type.BYTES);
            }
            if (input == DateType.INSTANCE) {
                return LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
            }
            if (input.getSuperType() != null && input.getSuperType().isSimpleType()) {
                return new LogicalType(this.getName(input)).addToSchema(this.createSchema(input.getSuperType()));
            }
        } else {
            if (input.isListType()) {
                Schema array = Schema.createArray((Schema)this.context.createSchema((Object)((ListType)input).getFieldType()));
                String logicalType = ((ListType)input).isArray() ? "array" : "list";
                new LogicalType(logicalType).addToSchema(array);
                return array;
            }
            if (input.isComplexType()) {
                return this.complexTypeFactory.createSchema((ComplexType)input);
            }
            if (input.isCompositeType()) {
                throw new NotImplementedException("Composite types are not supported yet");
            }
        }
        throw new NotImplementedException("Cannot create Avro type schema for nuxeo type: " + input);
    }

    public String getName(Type input) {
        return this.context.getService().encodeName(input.getName());
    }
}

