/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.download;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.io.download.DownloadHelper;
import org.nuxeo.runtime.api.Framework;

public class BufferingServletOutputStream
extends ServletOutputStream {
    private static final Log log = LogFactory.getLog(BufferingServletOutputStream.class);
    public static final int INITIAL = 4096;
    public static final int MAX = 65536;
    private static final OutputStream EMPTY = new ByteArrayOutputStream(0);
    protected boolean streaming;
    protected boolean needsFlush;
    protected boolean needsClose;
    protected final ServletOutputStream outputStream;
    protected PrintWriter writer;
    protected ByteArrayOutputStream memory;
    protected OutputStream file;
    protected File tmp;

    public BufferingServletOutputStream(ServletOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public PrintWriter getWriter() {
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this)));
        }
        return this.writer;
    }

    protected OutputStream getOutputStream(int len) throws IOException {
        int total;
        if (this.streaming) {
            return this.outputStream;
        }
        if (len == 0) {
            return EMPTY;
        }
        if (this.file != null) {
            return this.file;
        }
        if (this.memory == null) {
            if (len <= 65536) {
                this.memory = new ByteArrayOutputStream(Math.max(4096, len));
                return this.memory;
            }
            total = len;
        } else {
            total = this.memory.size() + len;
        }
        if (total <= 65536) {
            return this.memory;
        }
        this.createTempFile();
        this.file = new BufferedOutputStream(new FileOutputStream(this.tmp));
        if (this.memory != null) {
            this.memory.writeTo(this.file);
            this.memory = null;
        }
        return this.file;
    }

    protected void createTempFile() throws IOException {
        this.tmp = Framework.createTempFile((String)"nxout", null);
    }

    public void write(int b) throws IOException {
        this.getOutputStream(1).write(b);
    }

    public void write(byte[] b) throws IOException {
        this.getOutputStream(b.length).write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.getOutputStream(len).write(b, off, len);
    }

    public void flush() throws IOException {
        if (this.streaming) {
            this.outputStream.flush();
        } else {
            this.needsFlush = true;
        }
    }

    public void close() throws IOException {
        if (this.streaming) {
            this.outputStream.close();
        } else {
            this.needsClose = true;
        }
    }

    public boolean isCommitted() {
        return this.streaming;
    }

    public void resetBuffer() {
        if (this.streaming) {
            throw new IllegalStateException();
        }
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
            this.file = null;
            try {
                Files.delete(this.tmp.toPath());
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
            this.tmp = null;
        } else {
            this.memory = null;
        }
        this.needsFlush = false;
        this.needsClose = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopBuffering() throws IOException {
        if (this.streaming) {
            return;
        }
        if (this.writer != null) {
            this.writer.flush();
        }
        this.streaming = true;
        if (log.isDebugEnabled()) {
            long len = this.memory != null ? (long)this.memory.size() : (this.file != null ? this.tmp.length() : 0L);
            log.debug((Object)("buffered bytes: " + len));
        }
        boolean clientAbort = false;
        try {
            if (this.memory != null) {
                this.memory.writeTo((OutputStream)this.outputStream);
                return;
            }
            if (this.file == null) return;
            try {
                try {
                    this.file.flush();
                }
                finally {
                    this.file.close();
                }
                try (FileInputStream in = new FileInputStream(this.tmp);){
                    IOUtils.copy((InputStream)in, (OutputStream)this.outputStream);
                    return;
                }
                catch (IOException e) {
                    if (!DownloadHelper.isClientAbortError(e)) throw e;
                    DownloadHelper.logClientAbort(e);
                    clientAbort = true;
                    return;
                }
            }
            finally {
                Files.delete(this.tmp.toPath());
            }
        }
        catch (IOException e) {
            if (!DownloadHelper.isClientAbortError(e)) throw e;
            if (clientAbort) return;
            DownloadHelper.logClientAbort(e);
            clientAbort = true;
            return;
        }
        finally {
            block47: {
                this.memory = null;
                this.file = null;
                this.tmp = null;
                try {
                    if (this.needsFlush) {
                        this.outputStream.flush();
                    }
                }
                catch (IOException e) {
                    if (DownloadHelper.isClientAbortError(e)) {
                        if (!clientAbort) {
                            DownloadHelper.logClientAbort(e);
                        }
                        break block47;
                    }
                    log.error((Object)e);
                }
                finally {
                    if (this.needsClose) {
                        this.outputStream.close();
                    }
                }
            }
        }
    }

    public static void stopBuffering(OutputStream out) throws IOException {
        if (out instanceof BufferingServletOutputStream) {
            ((BufferingServletOutputStream)((Object)out)).stopBuffering();
        }
    }

    public boolean isReady() {
        if (this.streaming) {
            return this.outputStream.isReady();
        }
        return true;
    }

    public void setWriteListener(WriteListener writeListener) {
    }
}

