/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.enrichers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.apps.AppLink;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class BlobAppLinksJsonEnricher
extends AbstractJsonEnricher<BlobProperty> {
    public static final String NAME = "appLinks";

    public BlobAppLinksJsonEnricher() {
        super(NAME);
    }

    @Override
    public void write(JsonGenerator jg, BlobProperty blobProperty) throws IOException {
        Blob blob = (Blob)blobProperty.getValue();
        if (!(blob instanceof ManagedBlob)) {
            return;
        }
        ManagedBlob managedBlob = (ManagedBlob)blob;
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        BlobProvider blobProvider = blobManager.getBlobProvider(managedBlob.getProviderId());
        if (blobProvider == null) {
            return;
        }
        DocumentModel doc = (DocumentModel)this.ctx.getParameter("document");
        if (doc == null) {
            return;
        }
        jg.writeFieldName(NAME);
        jg.writeStartArray();
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(doc);){
            NuxeoPrincipal principal = wrapper.getSession().getPrincipal();
            if (principal != null) {
                List apps = blobProvider.getAppLinks(principal.getName(), managedBlob);
                for (AppLink app : apps) {
                    jg.writeObject((Object)app);
                }
            }
        }
        jg.writeEndArray();
    }
}

