/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.types;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.PrimitiveType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class SchemaJsonWriter
extends ExtensibleEntityJsonWriter<Schema> {
    public static final String ENTITY_TYPE = "schema";
    public static final String FETCH_FIELDS = "fields";

    public SchemaJsonWriter() {
        super(ENTITY_TYPE, Schema.class);
    }

    @Override
    protected void writeEntityBody(Schema schema, JsonGenerator jg) throws IOException {
        jg.writeStringField("name", schema.getName());
        String prefix = schema.getNamespace().prefix;
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            jg.writeStringField("prefix", prefix);
            jg.writeStringField("@prefix", prefix);
        }
        jg.writeObjectFieldStart(FETCH_FIELDS);
        for (Field field : schema.getFields()) {
            this.writeField(jg, field);
        }
        jg.writeEndObject();
    }

    protected void writeField(JsonGenerator jg, Field field) throws IOException {
        if (!field.getType().isComplexType()) {
            if (field.getType().isListType()) {
                ListType lt = (ListType)field.getType();
                if (lt.getFieldType().isComplexType()) {
                    if (lt.getFieldType().getName().equals("content")) {
                        jg.writeStringField(field.getName().getLocalName(), "blob[]");
                    } else {
                        jg.writeObjectFieldStart(field.getName().getLocalName());
                        jg.writeStringField("type", "complex[]");
                        jg.writeObjectFieldStart(FETCH_FIELDS);
                        ComplexType cplXType = (ComplexType)lt.getField().getType();
                        for (Field subField : cplXType.getFields()) {
                            this.writeField(jg, subField);
                        }
                        jg.writeEndObject();
                        jg.writeEndObject();
                    }
                } else {
                    this.doWriteField(jg, field);
                }
            } else {
                this.doWriteField(jg, field);
            }
        } else if (field.getType().getName().equals("content")) {
            jg.writeStringField(field.getName().getLocalName(), "blob");
        } else {
            jg.writeObjectFieldStart(field.getName().getLocalName());
            ComplexType cplXType = (ComplexType)field.getType();
            jg.writeObjectFieldStart(FETCH_FIELDS);
            for (Field subField : cplXType.getFields()) {
                this.writeField(jg, subField);
            }
            jg.writeEndObject();
            jg.writeStringField("type", "complex");
            jg.writeEndObject();
        }
    }

    protected void doWriteField(JsonGenerator jg, Field field) throws IOException {
        String typeValue;
        boolean extended = this.ctx.getFetched(ENTITY_TYPE).contains(FETCH_FIELDS);
        Set itemConstraints = null;
        if (field.getType().isListType()) {
            ListType lt = (ListType)field.getType();
            org.nuxeo.ecm.core.schema.types.Type type = lt.getFieldType();
            itemConstraints = type.getConstraints();
            while (!(type instanceof PrimitiveType)) {
                type = type.getSuperType();
            }
            typeValue = type.getName() + "[]";
        } else {
            org.nuxeo.ecm.core.schema.types.Type type = field.getType();
            while (!(type instanceof PrimitiveType)) {
                type = type.getSuperType();
            }
            typeValue = type.getName();
        }
        if (extended) {
            jg.writeObjectFieldStart(field.getName().getLocalName());
            jg.writeStringField("type", typeValue);
            Writer<Constraint> constraintWriter = this.registry.getWriter(this.ctx, Constraint.class, MediaType.APPLICATION_JSON_TYPE);
            OutputStreamWithJsonWriter out = new OutputStreamWithJsonWriter(jg);
            jg.writeArrayFieldStart("constraints");
            for (Constraint c : field.getConstraints()) {
                constraintWriter.write(c, Constraint.class, (Type)((Object)Constraint.class), MediaType.APPLICATION_JSON_TYPE, out);
            }
            jg.writeEndArray();
            if (itemConstraints != null) {
                jg.writeArrayFieldStart("itemConstraints");
                for (Constraint c : itemConstraints) {
                    constraintWriter.write(c, Constraint.class, (Type)((Object)Constraint.class), MediaType.APPLICATION_JSON_TYPE, out);
                }
                jg.writeEndArray();
            }
            jg.writeEndObject();
        } else {
            jg.writeStringField(field.getName().getLocalName(), typeValue);
        }
    }
}

