/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.registry.context;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.io.registry.MarshallingException;
import org.nuxeo.ecm.core.io.registry.context.DepthValues;
import org.nuxeo.ecm.core.io.registry.context.MaxDepthReachedException;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;

public final class WrappedContext {
    private WrappedContext parent;
    private RenderingContext ctx;
    private Map<String, Object> entries = new HashMap<String, Object>();

    private WrappedContext(RenderingContext ctx) {
        if (ctx == null) {
            throw new MarshallingException("Cannot get a wrapped context without RenderingContext");
        }
        this.ctx = ctx;
        this.parent = (WrappedContext)ctx.getParameter("_MarshalledEntitiesWrappedContext");
    }

    private static WrappedContext get(RenderingContext ctx) {
        if (ctx != null) {
            return (WrappedContext)ctx.getParameter("_MarshalledEntitiesWrappedContext");
        }
        throw new MarshallingException("Cannot get a wrapped context without RenderingContext");
    }

    static WrappedContext create(RenderingContext ctx) {
        if (ctx != null) {
            WrappedContext child = new WrappedContext(ctx);
            return child;
        }
        throw new MarshallingException("Cannot get a wrapped context without RenderingContext");
    }

    public final WrappedContext with(String key, Object value) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return this;
        }
        String realKey = key.toLowerCase().trim();
        this.entries.put(realKey, value);
        return this;
    }

    public final WrappedContext controlDepth() throws MaxDepthReachedException {
        Integer maxDepth;
        String depthKey = "_DepthControlKey_DEFAULT";
        Integer value = (Integer)WrappedContext.getEntity(this.ctx, depthKey);
        String depth = (String)this.ctx.getParameter("depth");
        if (depth == null) {
            maxDepth = DepthValues.root.getDepth();
        } else {
            try {
                maxDepth = DepthValues.valueOf(depth).getDepth();
            }
            catch (IllegalArgumentException | NullPointerException e) {
                maxDepth = DepthValues.root.getDepth();
            }
        }
        if (value == null) {
            value = 0;
        }
        Integer n = value;
        Integer n2 = value = Integer.valueOf(value + 1);
        if (value > maxDepth) {
            throw new MaxDepthReachedException();
        }
        this.entries.put(depthKey.toLowerCase(), value);
        return this;
    }

    public final Map<String, Object> flatten() {
        HashMap<String, Object> mergedResult = new HashMap<String, Object>();
        if (this.parent != null) {
            mergedResult.putAll(this.parent.flatten());
        }
        mergedResult.putAll(this.entries);
        return mergedResult;
    }

    static <T> T getEntity(RenderingContext ctx, String key) {
        T value = null;
        WrappedContext wrappedCtx = WrappedContext.get(ctx);
        if (wrappedCtx != null) {
            if (StringUtils.isEmpty((CharSequence)key)) {
                return null;
            }
            String realKey = key.toLowerCase().trim();
            return wrappedCtx.innerGetEntity(realKey);
        }
        return value;
    }

    private <T> T innerGetEntity(String entityType) {
        Object value = this.entries.get(entityType);
        if (value == null && this.parent != null) {
            return this.parent.innerGetEntity(entityType);
        }
        return (T)value;
    }

    public final Closeable open() {
        this.ctx.setParameterValues("_MarshalledEntitiesWrappedContext", this);
        return new Closeable(){

            @Override
            public void close() throws IOException {
                WrappedContext.this.ctx.setParameterValues("_MarshalledEntitiesWrappedContext", WrappedContext.this.parent);
            }
        };
    }

    public String toString() {
        return this.flatten().toString();
    }
}

