/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.nuxeo.ecm.core.io.marshallers.csv.OutputStreamWithCSVWriter;
import org.nuxeo.ecm.core.io.registry.MarshallerRegistry;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Supports;
import org.nuxeo.ecm.core.schema.SchemaManager;

@Supports(value={"text/csv"})
public abstract class AbstractCSVWriter<T>
implements Writer<T> {
    public static final String TEXT_CSV = "text/csv";
    public static final MediaType TEXT_CSV_TYPE = new MediaType("text", "csv");
    @Inject
    protected RenderingContext ctx;
    @Inject
    protected SchemaManager schemaManager;
    @Inject
    protected MarshallerRegistry registry;

    @Override
    public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
        return TEXT_CSV_TYPE.equals((Object)mediatype);
    }

    @Override
    public void write(T entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) throws IOException {
        CSVPrinter printer = this.getCSVPrinter(entity, out);
        this.write(entity, printer);
        printer.flush();
    }

    protected abstract void write(T var1, CSVPrinter var2) throws IOException;

    protected abstract void writeHeader(T var1, CSVPrinter var2) throws IOException;

    protected CSVPrinter getCSVPrinter(T entity, OutputStream out) throws IOException {
        CSVPrinter printer;
        if (out instanceof OutputStreamWithCSVWriter) {
            OutputStreamWithCSVWriter oscsv = (OutputStreamWithCSVWriter)out;
            if (oscsv.getCsvPrinter() != null) {
                return oscsv.getCsvPrinter();
            }
            printer = new CSVPrinter((Appendable)new StringBuilder(), CSVFormat.DEFAULT);
            oscsv.setCSVPrinter(printer);
        } else {
            printer = new CSVPrinter((Appendable)new OutputStreamWriter(out), CSVFormat.DEFAULT);
        }
        this.writeHeader(entity, printer);
        return printer;
    }

    protected void printCalendar(Calendar value, CSVPrinter printer) throws IOException {
        if (value != null) {
            printer.print((Object)((GregorianCalendar)value).toZonedDateTime());
        } else {
            printer.print(null);
        }
    }
}

