/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.nuxeo.ecm.core.io.marshallers.json.InputStreamWithJsonNode;
import org.nuxeo.ecm.core.io.marshallers.json.JsonFactoryProvider;
import org.nuxeo.ecm.core.io.registry.MarshallerRegistry;
import org.nuxeo.ecm.core.io.registry.Reader;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Supports;

@Supports(value={"application/json"})
public abstract class AbstractJsonReader<EntityType>
implements Reader<EntityType> {
    @Inject
    protected RenderingContext ctx;
    @Inject
    protected MarshallerRegistry registry;

    @Override
    public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
        return true;
    }

    @Override
    public EntityType read(Class<?> clazz, Type genericType, MediaType mediaType, InputStream in) throws IOException {
        JsonNode jn = this.getNode(in, true);
        return this.read(jn);
    }

    protected JsonNode getNode(InputStream in, boolean getCurrentIfAvailable) throws IOException, JsonParseException, JsonProcessingException {
        if (getCurrentIfAvailable && in instanceof InputStreamWithJsonNode) {
            return ((InputStreamWithJsonNode)in).getJsonNode();
        }
        try (JsonParser jp = JsonFactoryProvider.get().createParser(in);){
            JsonNode jsonNode = (JsonNode)jp.readValueAsTree();
            return jsonNode;
        }
    }

    public abstract EntityType read(JsonNode var1) throws IOException;

    protected <T> T readEntity(Class<?> clazz, Type genericType, JsonNode jn) throws IOException {
        Class<?> effectiveGenericType = genericType != null ? genericType : clazz;
        Reader<?> reader = this.registry.getReader(this.ctx, clazz, effectiveGenericType, MediaType.APPLICATION_JSON_TYPE);
        return (T)reader.read(clazz, effectiveGenericType, MediaType.APPLICATION_JSON_TYPE, new InputStreamWithJsonNode(jn));
    }

    protected String getStringField(JsonNode jn, String elName) {
        JsonNode elNode = jn.get(elName);
        if (elNode != null && !elNode.isNull() && elNode.isTextual()) {
            return elNode.textValue();
        }
        return null;
    }

    protected Boolean getBooleanField(JsonNode jn, String elName) {
        JsonNode elNode = jn.get(elName);
        if (elNode != null && !elNode.isNull()) {
            if (elNode.isBoolean()) {
                return elNode.booleanValue();
            }
            if (elNode.isTextual()) {
                return Boolean.valueOf(elNode.textValue());
            }
            return null;
        }
        return null;
    }

    protected Long getLongField(JsonNode jn, String elName) {
        JsonNode elNode = jn.get(elName);
        if (elNode != null && !elNode.isNull()) {
            if (elNode.isNumber()) {
                return elNode.longValue();
            }
            if (elNode.isTextual()) {
                return Long.valueOf(elNode.textValue());
            }
            return null;
        }
        return null;
    }

    protected List<String> getStringListField(JsonNode jn, String elName) {
        JsonNode elNode = jn.get(elName);
        if (elNode != null && !elNode.isNull()) {
            if (elNode.isArray()) {
                ArrayList<String> result = new ArrayList<String>();
                for (JsonNode subNode : elNode) {
                    String value = subNode != null && !subNode.isNull() && subNode.isTextual() ? subNode.textValue() : null;
                    result.add(value);
                }
                return result;
            }
            return null;
        }
        return null;
    }
}

