/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.output.WriterOutputStream;

public class OutputStreamWithJsonWriter
extends OutputStream {
    private OutputStream out;
    private JsonGenerator jsonGenerator;

    public OutputStreamWithJsonWriter(JsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
        Object outputTarget = jsonGenerator.getOutputTarget();
        if (outputTarget instanceof OutputStream) {
            this.out = (OutputStream)outputTarget;
        } else if (outputTarget instanceof Writer) {
            this.out = new WriterOutputStream((Writer)outputTarget, StandardCharsets.UTF_8);
        }
    }

    public JsonGenerator getJsonGenerator() {
        return this.jsonGenerator;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

