/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.enrichers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.Enriched;

public abstract class AbstractJsonEnricher<EntityType>
extends AbstractJsonWriter<Enriched<EntityType>> {
    private static final Logger log = LogManager.getLogger(AbstractJsonEnricher.class);
    public static final String ENTITY_ENRICHER_NAME = "_EntityEnricherName";
    private final String name;
    protected static final ObjectMapper MAPPER = new ObjectMapper();

    public AbstractJsonEnricher(String name) {
        this.name = name;
    }

    @Override
    public final boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
        return this.name.equals(this.ctx.getParameter(ENTITY_ENRICHER_NAME));
    }

    @Override
    public void write(Enriched<EntityType> enrichable, JsonGenerator jg) {
        try (TokenBuffer tb = new TokenBuffer((ObjectCodec)MAPPER, false);){
            tb.writeStartObject();
            this.write((JsonGenerator)tb, enrichable.getEntity());
            tb.writeEndObject();
            tb.flush();
            try (JsonParser parser = tb.asParser();){
                parser.nextToken();
                while (parser.nextToken() == JsonToken.FIELD_NAME) {
                    jg.copyCurrentStructure(parser);
                }
                if (parser.currentToken() != JsonToken.END_OBJECT) {
                    Supplier[] supplierArray = new Supplier[3];
                    supplierArray[0] = this.name::toString;
                    supplierArray[1] = () -> ((JsonParser)parser).currentToken();
                    supplierArray[2] = () -> this.safeReadBuffer(tb);
                    log.error("Enricher: {} failed on current token: {}, output to write: {}", supplierArray);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("interrupted", e);
            }
            log.warn("The following error occured with enricher: {}", (Object)this.name, (Object)e);
        }
    }

    protected String safeReadBuffer(TokenBuffer tb) {
        try {
            return (String)MAPPER.readTree(tb.asParser());
        }
        catch (IOException e) {
            return "malformed content could not be retrieved";
        }
    }

    public abstract void write(JsonGenerator var1, EntityType var2) throws IOException;
}

