/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.mongodb.seqgen;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Updates;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.uidgen.AbstractUIDSequencer;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.mongodb.MongoDBConnectionService;
import org.nuxeo.runtime.mongodb.MongoDBSerializationHelper;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class MongoDBUIDSequencer
extends AbstractUIDSequencer {
    private static final Log log = LogFactory.getLog(MongoDBUIDSequencer.class);
    public static final String SEQUENCE_DATABASE_ID = "sequence";
    public static final String COLLECTION_NAME_PROPERTY = "nuxeo.mongodb.seqgen.collection.name";
    public static final String DEFAULT_COLLECTION_NAME = "sequence";
    public static final String SEQUENCE_VALUE_FIELD = "sequence";
    protected MongoCollection<Document> coll;

    public void init() {
        this.getSequencerCollection();
    }

    public void initSequence(String key, long id) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)key), Filters.not((Bson)Filters.gte((String)"sequence", (Object)id))});
        Document sequence = new Document();
        sequence.put("_id", (Object)key);
        sequence.put("sequence", (Object)id);
        try {
            try {
                this.getSequencerCollection().replaceOne(filter, (Object)sequence, new ReplaceOptions().upsert(true));
            }
            catch (MongoWriteException e) {
                if (ErrorCategory.fromErrorCode((int)e.getCode()) != ErrorCategory.DUPLICATE_KEY) {
                    throw e;
                }
                this.getSequencerCollection().replaceOne(filter, (Object)sequence, new ReplaceOptions().upsert(true));
            }
        }
        catch (MongoWriteException e) {
            throw new NuxeoException("Failed to update the sequence '" + key + "' with value " + id, (Throwable)e);
        }
    }

    public MongoCollection<Document> getSequencerCollection() {
        if (this.coll == null) {
            ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
            String collName = configurationService.getProperty(COLLECTION_NAME_PROPERTY, "sequence");
            MongoDBConnectionService mongoService = (MongoDBConnectionService)Framework.getService(MongoDBConnectionService.class);
            MongoDatabase database = mongoService.getDatabase("sequence");
            this.coll = database.getCollection(collName);
        }
        return this.coll;
    }

    public long getNextLong(String key) {
        return this.incrementBy(key, 1);
    }

    public List<Long> getNextBlock(String key, int blockSize) {
        ArrayList<Long> ret = new ArrayList<Long>(blockSize);
        long last = this.incrementBy(key, blockSize);
        for (int i = blockSize - 1; i >= 0; --i) {
            ret.add(last - (long)i);
        }
        return ret;
    }

    protected long incrementBy(String key, int value) {
        FindOneAndUpdateOptions options = new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER);
        Bson filter = Filters.eq((String)"_id", (Object)key);
        Bson update = Updates.inc((String)"sequence", (Number)value);
        Document sequence = (Document)this.getSequencerCollection().findOneAndUpdate(filter, update, options);
        if (sequence == null) {
            try {
                sequence = new Document();
                sequence.put("_id", (Object)key);
                sequence.put("sequence", (Object)value);
                this.getSequencerCollection().insertOne((Object)sequence);
            }
            catch (MongoWriteException e) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("There was a race condition during '" + key + "' sequence insertion"), (Throwable)e);
                }
                return this.getNextLong(key);
            }
        }
        return (Long)MongoDBSerializationHelper.bsonToFieldMap((Document)sequence).get("sequence");
    }

    public void dispose() {
        if (this.coll != null) {
            this.coll = null;
        }
    }
}

