/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;

public class EventImpl
implements Event {
    private static final long serialVersionUID = 1L;
    protected final String name;
    protected final long time;
    protected final EventContext ctx;
    protected int flags;
    protected Exception rollbackException;
    protected String rollbackMessage;

    public EventImpl(String name, EventContext ctx, int flags, long creationTime) {
        this.name = name;
        this.ctx = ctx;
        this.time = creationTime;
        this.flags = flags;
    }

    public EventImpl(String name, EventContext ctx, int flags) {
        this(name, ctx, flags, System.currentTimeMillis());
    }

    public EventImpl(String name, EventContext ctx) {
        this(name, ctx, 0);
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public EventContext getContext() {
        return this.ctx;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public void cancel() {
        this.flags |= 1;
    }

    @Override
    public void markRollBack() {
        this.flags |= 2;
    }

    @Override
    public void markRollBack(String message, Exception exception) {
        this.markRollBack();
        if (message == null && exception != null) {
            message = exception.getMessage();
        }
        this.rollbackMessage = message;
        this.rollbackException = exception;
    }

    @Override
    public void markBubbleException() {
        this.flags |= 0x40;
    }

    @Override
    public boolean isBubbleException() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public boolean isMarkedForRollBack() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isCanceled() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isInline() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public void setInline(boolean isInline) {
        this.flags = isInline ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    @Override
    public boolean isCommitEvent() {
        return (this.flags & 4) != 0;
    }

    @Override
    public void setIsCommitEvent(boolean isCommit) {
        this.flags = isCommit ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    @Override
    public boolean isImmediate() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public void setImmediate(boolean immediate) {
        this.flags = immediate ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    @Override
    public Exception getRollbackException() {
        return this.rollbackException;
    }

    @Override
    public String getRollbackMessage() {
        return this.rollbackMessage;
    }
}

