/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;

public class WorkStateHelper {
    private static final Logger log = LogManager.getLogger(WorkStateHelper.class);
    protected static final String KV_NAME = "workManager";
    protected static final String STATE_SUFFIX = ":state";
    protected static final String OFFSET_SUFFIX = ":offset";
    protected static final String GROUP_JOIN_COUNT_SUFFIX = ":group";
    protected static final long GROUP_JOIN_COUNT_TTL_SECONDS = 600L;
    protected static final String CANCELED = "canceled";

    protected static KeyValueStore getKeyValueStore() {
        return ((KeyValueService)Framework.getService(KeyValueService.class)).getKeyValueStore(KV_NAME);
    }

    protected static long getLastOffset(String workId) {
        String stringOffset = WorkStateHelper.getKeyValueStore().getString(WorkStateHelper.getOffsetKey(workId));
        return stringOffset == null ? -1L : Long.parseLong(stringOffset);
    }

    protected static String getOffsetKey(String workId) {
        return workId + OFFSET_SUFFIX;
    }

    protected static Work.State getState(String workId) {
        String stringState = WorkStateHelper.getKeyValueStore().getString(WorkStateHelper.getStateKey(workId));
        return stringState == null || CANCELED.equals(stringState) ? null : Work.State.valueOf(stringState);
    }

    protected static String getStateKey(String workId) {
        return workId + STATE_SUFFIX;
    }

    protected static String getGroupKey(String group) {
        return group + GROUP_JOIN_COUNT_SUFFIX;
    }

    protected static boolean isCanceled(String workId) {
        return CANCELED.equals(WorkStateHelper.getKeyValueStore().getString(WorkStateHelper.getStateKey(workId)));
    }

    protected static void setCanceled(String workId) {
        WorkStateHelper.getKeyValueStore().put(WorkStateHelper.getStateKey(workId), CANCELED, 0L);
    }

    protected static void setLastOffset(String workId, Long offset, long ttl) {
        WorkStateHelper.getKeyValueStore().put(WorkStateHelper.getOffsetKey(workId), offset == null ? null : offset, ttl);
    }

    protected static void setState(String workId, Work.State state, long ttl) {
        WorkStateHelper.getKeyValueStore().put(WorkStateHelper.getStateKey(workId), state == null ? null : state.toString(), ttl);
    }

    protected static void addGroupJoinWork(String group) {
        WorkStateHelper.getKeyValueStore().addAndGet(WorkStateHelper.getGroupKey(group), 1L);
    }

    protected static boolean removeGroupJoinWork(String group) {
        long count = WorkStateHelper.getKeyValueStore().addAndGet(WorkStateHelper.getGroupKey(group), -1L);
        if (count <= 0L) {
            WorkStateHelper.getKeyValueStore().setTTL(group, 600L);
            return true;
        }
        return false;
    }

    private WorkStateHelper() {
    }

    public static boolean removeGroupJoinWork(Work work) {
        log.error("removeGroupJoinWork: {} and {}", (Object)work.getClass().getSimpleName(), (Object)work.getPartitionKey());
        return WorkStateHelper.removeGroupJoinWork(work.getPartitionKey());
    }
}

