/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.core.event.impl.EventBundleImpl;
import org.nuxeo.ecm.core.event.script.Script;
import org.nuxeo.ecm.core.event.script.ScriptingEventListener;
import org.nuxeo.ecm.core.event.script.ScriptingPostCommitEventListener;
import org.nuxeo.runtime.model.RuntimeContext;

@XObject(value="listener")
public class EventListenerDescriptor {
    public static final Log log = LogFactory.getLog(EventListenerDescriptor.class);
    @XNode(value="@name")
    protected String name;
    @XNode(value="@class")
    protected String className;
    @XNode(value="@script")
    protected String script;
    @XNode(value="@postCommit")
    protected boolean isPostCommit;
    @XNode(value="@async")
    protected Boolean isAsync;
    @XNode(value="@transactionTimeOut")
    protected Integer transactionTimeOut;
    @XNode(value="@priority")
    protected Integer priority;
    @XNode(value="@enabled")
    protected boolean isEnabled = true;
    @XNode(value="@retryCount")
    protected Integer retryCount;
    @XNode(value="@singlethread")
    protected boolean singleThreaded = false;
    protected Set<String> events;
    protected RuntimeContext rc;
    protected EventListener inLineListener;
    protected PostCommitEventListener postCommitEventListener;

    public int getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    public void setRuntimeContext(RuntimeContext rc) {
        this.rc = rc;
    }

    public RuntimeContext getRuntimeContext() {
        return this.rc;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public Set<String> getEvents() {
        return this.events;
    }

    @XNodeList(value="event", componentType=String.class, type=HashSet.class, nullByDefault=true)
    public void setEvents(Set<String> events) {
        this.events = events.isEmpty() ? null : events;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    public void initListener() {
        block10: {
            try {
                if (this.className != null) {
                    Class klass;
                    try {
                        klass = this.getRuntimeContext().loadClass(this.className);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    if (EventListener.class.isAssignableFrom(klass)) {
                        this.inLineListener = (EventListener)klass.newInstance();
                        this.isPostCommit = false;
                        break block10;
                    }
                    if (PostCommitEventListener.class.isAssignableFrom(klass)) {
                        this.postCommitEventListener = (PostCommitEventListener)klass.newInstance();
                        this.isPostCommit = true;
                        break block10;
                    }
                    throw new IllegalArgumentException("Listener extension must define a class extending EventListener or PostCommitEventListener: '" + this.className + "'.");
                }
                if (this.script != null) {
                    if (this.isPostCommit) {
                        this.postCommitEventListener = new ScriptingPostCommitEventListener(this.getScript());
                    } else {
                        this.inLineListener = new ScriptingEventListener(this.getScript());
                    }
                    break block10;
                }
                throw new IllegalArgumentException("Listener extension must define either a class or a script");
            }
            catch (IOException | NoClassDefFoundError | ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public EventListener asEventListener() {
        return this.inLineListener;
    }

    public PostCommitEventListener asPostCommitListener() {
        return this.postCommitEventListener;
    }

    public Script getScript() throws IOException {
        if (this.rc != null) {
            URL url = this.rc.getBundle().getEntry(this.script);
            if (url == null && (url = this.rc.getResource(this.script)) == null) {
                throw new IOException("Script Not found: " + this.script);
            }
            return Script.newScript(url);
        }
        return Script.newScript(this.script);
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.className != null ? this.className : this.script;
        }
        return this.name;
    }

    public Integer getTransactionTimeout() {
        return this.transactionTimeOut;
    }

    public void merge(EventListenerDescriptor other) {
        this.isEnabled = other.isEnabled;
        if (other.className != null) {
            this.className = other.className;
            this.rc = other.rc;
        } else if (other.script != null) {
            this.script = other.script;
            this.className = null;
            this.rc = other.rc;
        }
        if (other.isAsync != null) {
            this.isAsync = other.isAsync;
        }
        if (other.events != null) {
            this.events = other.events;
        }
        if (other.transactionTimeOut != null) {
            this.transactionTimeOut = other.transactionTimeOut;
        }
        if (other.priority != null) {
            this.priority = other.priority;
        }
        if (other.retryCount != null) {
            this.retryCount = other.retryCount;
        }
    }

    public final boolean acceptEvent(String eventName) {
        return this.events == null || this.events.contains(eventName);
    }

    public void setIsAsync(Boolean isAsync) {
        this.isAsync = isAsync;
    }

    public boolean getIsAsync() {
        return this.isAsync == null ? false : this.isAsync;
    }

    public boolean isSingleThreaded() {
        return this.singleThreaded;
    }

    public EventBundle filterBundle(EventBundle bundle) {
        EventBundleImpl filtered = new EventBundleImpl();
        for (Event event : bundle) {
            PostCommitEventListener pcl;
            if (!this.acceptEvent(event.getName()) || (pcl = this.asPostCommitListener()) instanceof PostCommitFilteringEventListener && !((PostCommitFilteringEventListener)pcl).acceptEvent(event)) continue;
            filtered.push(event);
        }
        return filtered;
    }

    public boolean acceptBundle(EventBundle bundle) {
        for (Event event : bundle) {
            PostCommitEventListener pcl;
            if (!this.acceptEvent(event.getName()) || (pcl = this.asPostCommitListener()) instanceof PostCommitFilteringEventListener && !((PostCommitFilteringEventListener)pcl).acceptEvent(event)) continue;
            return true;
        }
        return false;
    }
}

