/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.util.UUID;
import org.nuxeo.ecm.core.work.AbstractWork;

public class SlowWork
extends AbstractWork {
    private static final long serialVersionUID = 2L;
    protected final long durationMs;

    public SlowWork(long durationMs) {
        super(UUID.randomUUID().toString());
        this.durationMs = durationMs;
    }

    @Override
    public void work() {
        try {
            Thread.sleep(this.durationMs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getTitle() {
        return "SlowWork " + this.durationMs + " ms";
    }
}

