/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture;

import java.io.IOException;
import java.io.Serializable;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class PictureViewsHelper {
    private static final Logger log = LogManager.getLogger(PictureViewsHelper.class);
    public static final String PICTURE_VIEWS_TX_TIMEOUT_PROPERTY = "nuxeo.picture.views.transaction.timeout.seconds";
    public static final int DEFAULT_TX_TIMEOUT_SECONDS = 300;
    protected static final String NOTHING_TO_PROCESS_MESSAGE = "Nothing to process";
    protected Integer transactionTimeout;

    public void computePictureViews(CoreSession session, String id, String xpath, Consumer<String> statusSetter) {
        if (!session.exists((DocumentRef)new IdRef(id))) {
            log.debug("Doc id doesn't exist: {}", (Object)id);
            statusSetter.accept(NOTHING_TO_PROCESS_MESSAGE);
            return;
        }
        DocumentModel workingDocument = session.getDocument((DocumentRef)new IdRef(id));
        Blob blob = null;
        try {
            Property fileProp = workingDocument.getProperty(xpath);
            blob = (Blob)fileProp.getValue();
        }
        catch (PropertyNotFoundException e) {
            log.debug("No property: {} for doc: {}", (Object)xpath, (Object)id);
        }
        if (blob == null) {
            log.debug("No blob for doc: {}", (Object)workingDocument);
            statusSetter.accept(NOTHING_TO_PROCESS_MESSAGE);
            return;
        }
        String title = workingDocument.getTitle();
        statusSetter.accept("Generating views");
        try {
            PictureResourceAdapter picture = (PictureResourceAdapter)workingDocument.getAdapter(PictureResourceAdapter.class);
            log.debug("Fill picture views for doc: {}", (Object)workingDocument);
            picture.fillPictureViews(blob, blob.getFilename(), title, null);
        }
        catch (DocumentNotFoundException e) {
            statusSetter.accept(NOTHING_TO_PROCESS_MESSAGE);
            return;
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        if (!session.exists((DocumentRef)new IdRef(id))) {
            log.debug("Doc id doesn't exist: {}", (Object)id);
            statusSetter.accept(NOTHING_TO_PROCESS_MESSAGE);
            return;
        }
        statusSetter.accept("Saving");
        if (workingDocument.isVersion()) {
            workingDocument.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        workingDocument.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("disablePictureViewsGenerationListener", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("disableDublinCoreListener", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("DisableAutomaticVersioning", (Serializable)Boolean.TRUE);
        session.saveDocument(workingDocument);
        statusSetter.accept("Done");
    }

    public void newTransaction() {
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
        }
        log.debug("Commit and start transaction with timeout {}s", new Supplier[]{this::getTransactionTimeout});
        TransactionHelper.startTransaction((int)this.getTransactionTimeout());
    }

    public int getTransactionTimeout() {
        if (this.transactionTimeout == null) {
            String maxDurationStr = Framework.getProperty((String)PICTURE_VIEWS_TX_TIMEOUT_PROPERTY, (String)String.valueOf(300));
            this.transactionTimeout = Integer.parseInt(maxDurationStr);
        }
        return this.transactionTimeout;
    }
}

